drop table if exists ndd_market_lavka;
create temporary table ndd_market_lavka as

with a as (
         select msk_delivered_dttm::date as date,
                b.country,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_k2 a
                  inner join (
             select distinct name_ru, tz_country_name_ru as country
             from core_cdm_geo.v_dim_op_geo_hierarchy
         ) b
                             on a.region_name = b.name_ru
         where pickup_or_lavka = 'lavka'
         group by 1, 2

         union all

         select msk_delivered_dttm::date as date,
                b.country,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_ts a
                  inner join (
             select distinct name_ru, tz_country_name_ru as country
             from core_cdm_geo.v_dim_op_geo_hierarchy
         ) b on a.region_name = b.name_ru
         group by 1, 2
     )
select
    date,
    'NDD'::text as tariff,
    country,
    'INTERCO'::text as tier,
    sum(deliveries) as deliveries,
    sum(0) as gmv,
    sum(0) as net_inflow
from a
group by 1,3

;



drop table if exists ndd_deliveries;
CREATE TEMP TABLE ndd_deliveries as
select
    first_day as date,
    'NDD' as tariff,
    country,
   case
       when manager_metagroup = 'INTERCO' then 'INTERCO'
       when manager_metagroup = 'Тир 1' then 'Tier 1'
       when manager_metagroup in ('Тир 2','СНГ','Израиль') then 'Tier 2'
       when manager_metagroup = 'Тир 3' then 'Tier 3'
       when manager_metagroup is null then 'B2B Platform'
       else 'Tier 4'
       end as tier,
    count (distinct request_id) as deliveries,
    sum(0) as gmv,
    sum(0) as net_inflow

from
    (
        select distinct
            request_id,
            a.corp_client_id,
            mangr.manager_metagroup,
            coalesce(delivery_country, 'Россия') as country,
            coalesce(geo.tz_aggl_name_ru, 'Москва') as city,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from
            snb_delivery.logdata_ndd_requests_datamart a
            left join core_cdm_geo.v_dim_fi_geo_hierarchy geo
                on a.delivery_region = geo.geobase_id
            left join
                (
                    select corp_client_id, max(manager_metagroup) as manager_metagroup
                    from snb_delivery.niksm_contract_manager
                    group by 1
                ) as mangr
                on mangr.corp_client_id = a.corp_client_id
        where
            mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
            and tech_event_instant_ddtm::date <= current_date - interval '1 day'
    ) ndd
group by
    1,2,3,4;



drop table if exists result;
create temp table result as
    select date,
           case
               when tariff = 'K2' then 'NDD' else tariff
               end::text as tariff,
           country,
           case
                when tariff_class_code in ('ubernight','uberlux') then 'Uber'
                when tariff = 'K2' or client in ('Еда - рестораны', 'Еда - ритейл', 'Лавка', 'Маркет', 'INTERCO') then 'INTERCO'
                when corp_client_id is not null then
                    case
                        when manager_metagroup = 'INTERCO' then 'INTERCO'
                        when manager_metagroup = 'Тир 1' then 'Tier 1'
                        when manager_metagroup in ('Тир 2','СНГ','Израиль') then 'Tier 2'
                        when manager_metagroup = 'Тир 3' or phoenix then 'Tier 3'
                        when manager_metagroup = 'Партнерские продажи' then 'Franchise'
                        when manager_metagroup is null then 'B2B Platform'
                    end
                    else case
                        when c2c_smb_b2b_flg = 'SMB' then 'Tier 4'
                        when c2c_smb_b2b_flg = 'C2C' then 'C2C'
                        else coalesce(manager_group,'Other')
                    end
               end::text as tier,
           sum(deliveries)                       as deliveries,
           sum(gmv)                              as gmv,
           sum(net_inflow)                       as net_inflow
    from
        snb_delivery.data_bizdev
    where
        same_or_next_day_fake in ('Same', 'Next_Pvz')
    group by
        1, 2, 3, 4

    union all

    select date,
           'NDD' as tariff,
           country,
           case
                when tariff_class_code in ('ubernight','uberlux') then 'Uber'
                when tariff = 'K2' or client in ('Еда - рестораны', 'Еда - ритейл', 'Лавка', 'Маркет', 'INTERCO') then 'INTERCO'
                when corp_client_id is not null then
                    case
                        when manager_metagroup = 'INTERCO' then 'INTERCO'
                        when manager_metagroup = 'Тир 1' then 'Tier 1'
                        when manager_metagroup in ('Тир 2','СНГ','Израиль') then 'Tier 2'
                        when manager_metagroup = 'Тир 3' or phoenix then 'Tier 3'
                        when manager_metagroup = 'Партнерские продажи' then 'Franchise'
                        when manager_metagroup is null then 'B2B Platform'
                    end
                    else case
                        when c2c_smb_b2b_flg = 'SMB' then 'Tier 4'
                        when c2c_smb_b2b_flg = 'C2C' then 'C2C'
                        else coalesce(manager_group,'Other')
                    end
               end::text as tier,
           sum(0)                       as deliveries,
           sum(gmv)                              as gmv,
           sum(net_inflow)                       as net_inflow

    from
        snb_delivery.data_bizdev
    where
        same_or_next_day_fake = 'Next'
    group by
        1, 2, 3, 4

    union all

    select
        date,
        tariff,
        country,
        tier,
        deliveries,
        gmv,
        net_inflow
    from ndd_market_lavka

    union all

    select
        date,
        tariff,
        country,
        tier,
        deliveries,
        gmv,
        net_inflow
    from ndd_deliveries
;


drop table if exists snb_delivery.data_growth_by_tier;
create table snb_delivery.data_growth_by_tier as
with a as (
    select date,
           tariff,
           country,
           tier,
           sum(deliveries) as deliveries,
           sum(gmv)        as gmv,
           sum(net_inflow) as net_inflow
    from result
    where date <> current_date
    group by 1, 2, 3, 4
)
select
    coalesce(a.date, b.date, c.date) as date,
    coalesce(a.tariff, b.tariff, c.tariff) as tariff,
    coalesce(a.country, b.country, c.country) as country,
    coalesce(a.tier, b.tier, c.tier) as tier,
    unnest(array['deliveries','gmv','net_inflow']) as metric,
    unnest(array[a.deliveries::float, a.gmv::float, a.net_inflow::float]) as fact,
    unnest(array[b.deliveries, 0, 0]) as plan,
    unnest(array[
        case when coalesce(a.date, b.date, c.date) < current_date then a.deliveries else c."value_ML_deliveries" end,
        case when coalesce(a.date, b.date, c.date) < current_date then a.gmv else c."value_ML_gmv" end,
        case when coalesce(a.date, b.date, c.date) < current_date then a.net_inflow else c."value_ML_net_inflow" end
        ]) as forecast_ml
from
    a
    full join snb_delivery.plans_growth_by_tier b
        using (date, tariff, country, tier)
    full join snb_delivery.data_growth_by_tier_ml c
        using (date, tariff, country, tier);



alter table snb_delivery.data_growth_by_tier
add column max_date date,
add column current_month boolean,

add column text_yesterday text,
add column is_yesterday_curr boolean,
add column is_yesterday_prev boolean,
add column is_yesterday_prev2 boolean,

add column text_weektodate text,
add column is_weektodate_curr boolean,
add column is_weektodate_prev boolean,
add column is_weektodate_prev2 boolean,

add column text_lastfullweek text,
add column is_lastfullweek_curr boolean,
add column is_lastfullweek_prev boolean,
add column is_lastfullweek_prev2 boolean,

add column text_monthtodate text,
add column is_monthtodate_curr boolean,
add column is_monthtodate_prev boolean,
add column is_monthtodate_prev2 boolean,

add column text_lastfullmonth text,
add column is_lastfullmonth_curr boolean,
add column is_lastfullmonth_prev boolean,
add column is_lastfullmonth_prev2 boolean,

add column text_last7days text,
add column is_last7days_curr boolean,
add column is_last7days_prev boolean,
add column is_last7days_prev2 boolean;


update snb_delivery.data_growth_by_tier
set max_date = (select max(date) from snb_delivery.data_growth_by_tier where fact is not null);

update snb_delivery.data_growth_by_tier
set
    current_month = date_trunc('month',date) = date_trunc('month',max_date),
    is_yesterday_curr = date between max_date and max_date,
    is_yesterday_prev = date between max_date - 1 and max_date - 1,
    is_yesterday_prev2 = date between max_date - 7 and max_date - 7,
    is_weektodate_curr = date between date_trunc('week',max_date) and max_date,
    is_weektodate_prev = date between date_trunc('week',max_date - interval '1 week') and (max_date - interval '1 week'),
    is_weektodate_prev2 = date between date_trunc('week',max_date - interval '4 weeks') and (max_date - interval '4 weeks'),
    is_lastfullweek_curr = date between (date_trunc('week',max_date+1) - interval '1 week') and (date_trunc('week',max_date+1) - interval '1 day'),
    is_lastfullweek_prev = date between (date_trunc('week',max_date+1) - interval '2 weeks') and (date_trunc('week',max_date+1) - interval '1 week' - interval '1 day'),
    is_lastfullweek_prev2 = date between (date_trunc('week',max_date+1) - interval '5 weeks') and (date_trunc('week',max_date+1) - interval '4 weeks' - interval '1 day'),
    is_monthtodate_curr = date between date_trunc('month',max_date) and max_date,
    is_monthtodate_prev = date between (date_trunc('month',max_date) - interval '1 month') and (max_date - interval '1 month'),
    is_monthtodate_prev2 = date between (date_trunc('month',max_date) - interval '1 year') and (max_date - interval '1 year' - interval '1 day'),
    is_lastfullmonth_curr = date between (date_trunc('month',max_date+1) - interval '1 month') and (date_trunc('month',max_date+1) - interval '1 day'),
    is_lastfullmonth_prev = date between (date_trunc('month',max_date+1) - interval '2 months') and (date_trunc('month',max_date+1) - interval '1 month' - interval '1 day'),
    is_lastfullmonth_prev2 = date between (date_trunc('month',max_date+1) - interval '13 months') and (date_trunc('month',max_date+1) - interval '12 months' - interval '1 day'),
    is_last7days_curr = date between max_date - 6 and max_date,
    is_last7days_prev = date between max_date - 13 and max_date - 7,
    is_last7days_prev2 = date between max_date - 34 and max_date - 28,
    text_yesterday = 'Current: ' || max_date::date || ' to ' || max_date::date ||
                     '. Previous: ' || (max_date - 1)::date || ' to ' || (max_date - 1)::date ||
                     '. Before previous: ' || (max_date - 7)::date || ' to ' || (max_date - 7)::date || '.',
    text_weektodate = 'Current: ' || (date_trunc('week',max_date))::date || ' to ' || (max_date)::date ||
                     '. Previous: ' || (date_trunc('week',max_date - interval '1 week'))::date || ' to ' || (max_date - interval '1 week')::date ||
                     '. Before previous: ' || (date_trunc('week',max_date - interval '4 weeks'))::date || ' to ' || (max_date - interval '4 weeks')::date || '.',
    text_lastfullweek = 'Current: ' || (date_trunc('week',max_date+1) - interval '1 week')::date || ' to ' || (date_trunc('week',max_date+1) - interval '1 day')::date ||
                     '. Previous: ' || (date_trunc('week',max_date+1) - interval '2 weeks')::date || ' to ' || (date_trunc('week',max_date+1) - interval '1 week' - interval '1 day')::date ||
                     '. Before previous: ' || (date_trunc('week',max_date+1) - interval '5 weeks')::date || ' to ' || (date_trunc('week',max_date+1) - interval '4 weeks' - interval '1 day')::date || '.',
    text_monthtodate = 'Current: ' || (date_trunc('month',max_date))::date || ' to ' || (max_date)::date ||
                     '. Previous: ' || (date_trunc('month',max_date) - interval '1 month')::date || ' to ' || (max_date - interval '1 month')::date ||
                     '. Before previous: ' || (date_trunc('month',max_date) - interval '1 year')::date || ' to ' || (max_date - interval '1 year' - interval '1 day')::date || '.',
    text_lastfullmonth = 'Current: ' || (date_trunc('month',max_date+1) - interval '1 month')::date || ' to ' || (date_trunc('month',max_date+1) - interval '1 day')::date ||
                     '. Previous: ' || (date_trunc('month',max_date+1) - interval '2 months')::date || ' to ' || (date_trunc('month',max_date+1) - interval '1 month' - interval '1 day')::date ||
                     '. Before previous: ' || (date_trunc('month',max_date+1) - interval '13 months')::date || ' to ' || (date_trunc('month',max_date+1) - interval '12 months' - interval '1 day')::date || '.',
    text_last7days = 'Current: ' || (max_date - 6)::date || ' to ' || (max_date)::date ||
                     '. Previous: ' || (max_date - 13)::date || ' to ' || (max_date - 7)::date ||
                     '. Before previous: ' || (max_date - 34)::date || ' to ' || (max_date - 28)::date || '.';

grant select on snb_delivery.data_growth_by_tier to public;

comment on table snb_delivery.data_growth_by_tier is 'Данные для деша Growth. LOGDATA-1001';
