drop table if exists ru_geo;
create temp table ru_geo as
select geo.tariff_zone,
       geo.tz_aggl_name_en,
       coalesce(
               coalesce(mow.name_en, case when spb.region = 'SPb and SPb region' then 'SPb region' else spb.region end),
               geo.name_en) as region
from core_cdm_geo.v_dim_full_geo_hierarchy as geo
         left join (select distinct tariff_zone, name_en
                    from core_cdm_geo.v_dim_full_geo_hierarchy
                    where name_en in ('Moscow (Middle Region)',
                                      'Moscow (Near Region)',
                                      'Moscow (adm)',
                                      'Far Moscow Region')) as mow
                   on geo.tariff_zone = mow.tariff_zone
         left join (select min(name_en) as region,
                           tariff_zone
                    from core_cdm_geo.v_dim_full_geo_hierarchy
                    where name_en in ('SPb and SPb region', 'Saint-Petersburg (adm)')
                    group by tariff_zone) as spb
                   on geo.tariff_zone = spb.tariff_zone
where geo.tag_list = '{federal district}'
;

-- FULL HIERARCHY WITH RUSSIAN REGIONS
drop table if exists regions_geo;
create temp table regions_geo as
select
    h.tariff_zone,
    h.geobase_id,
    h.name_ru,
    h.name_en as tz_aggl_name_en,
    h.tz_country_name_en,
    coalesce(region, h.tz_country_name_en) as region_name_en,
    total_population,
    population_group
from
     core_cdm_geo.v_dim_full_geo_hierarchy h
     left join ru_geo r
               on r.tariff_zone = h.tariff_zone
where
    h.node_type = 'agglomeration'
    and h.root_node_id = 'br_root';



drop table if exists b2b_platform_industry_mapping;
create temp table b2b_platform_industry_mapping as
select
    c.corp_client_id,
    max(f.name_en) as industry
from
    snb_delivery.dm_sf_industry c
    left join snb_delivery.industries_b2b_dict e
        on e.b2b_industry = c.industry_name
    left join snb_delivery.industries_dict f
        on f.name_ru = e.delivery_industry
group by 1;


drop table if exists smb_industry_mapping;
create temp table smb_industry_mapping as
select
    b.user_phone_pd_id,
    d.name_en as industry
from
    snb_delivery.industries_final b
    left join snb_delivery.industries_dict d
        on d.name_ru = b.industry;




drop table if exists ndd_market_lavka;
create temporary table ndd_market_lavka as

with a as (
         select msk_delivered_dttm::date as date,
                c.country,
                c.region_name_en as region,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_k2 a
            left join (
                select distinct name_ru            as city_ru,
                                tz_aggl_name_en    as city_en,
                                tz_country_name_en as country,
                                case when tz_aggl_name_en in ('Moscow','Saint-Petersburg') then tz_aggl_name_en || ' (adm)' else region_name_en end as region_name_en
                from regions_geo) c
                on a.region_name = c.city_ru
         where pickup_or_lavka = 'lavka'
         group by 1, 2, 3

         union all

         select msk_delivered_dttm::date as date,
                c.country,
                c.region_name_en as region,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_ts a
            left join (
                select distinct name_ru            as city_ru,
                                tz_aggl_name_en    as city_en,
                                tz_country_name_en as country,
                                case when tz_aggl_name_en in ('Moscow','Saint-Petersburg') then tz_aggl_name_en || ' (adm)' else region_name_en end as region_name_en
                from regions_geo) c
                on a.region_name = c.city_ru
         group by 1, 2, 3
     )
select
    date,
    'NDD'::text as tariff,
    country,
    'INTERCO'::text as tier,
    region,
    'Yandex'::text as industry,
    'API'::text as channel,
    sum(deliveries) as deliveries,
    sum(0) as gmv,
    sum(0) as net_inflow
from a
group by 1,3,5

;



drop table if exists ndd_deliveries;
CREATE TEMP TABLE ndd_deliveries as
select
    first_day as date,
    'NDD' as tariff,
    country,
   case
       when manager_group = 'INTERCO' then 'INTERCO'
       when manager_group in ('ГПП','ГПП 1','ГПП 2') then 'Tier 1'
       when manager_group in ('ГМП','ГМП 1','ГМП 2','ГМП NDD','СНГ','Израиль') then 'Tier 2'
       when manager_group = 'Тир 3' then 'Tier 3'
       else 'Tier 4'
       end as tier,
    region,
    case
       when manager_group = 'INTERCO' then 'Yandex'
       else 'NDD other'
       end::text as industry,
    'API'::text as channel,
    count (distinct request_id) as deliveries,
    sum(0) as gmv,
    sum(0) as net_inflow

from
    (
        select distinct
            request_id,
            a.corp_client_id,
            mangr.manager_group,
            coalesce(c.country,'Russia') as country,
            coalesce(c.region_name_en,'Moscow') as region,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from
            snb_delivery.logdata_ndd_requests_datamart a
            left join (select geobase_id, max(tz_aggl_name_ru) as tz_aggl_name_ru from core_cdm_geo.v_dim_fi_geo_hierarchy group by 1) geo
                on a.delivery_region = geo.geobase_id
            left join
                (
                    select corp_client_id, max(manager_group) as manager_group
                    from snb_delivery.niksm_contract_manager
                    group by 1
                ) as mangr
                on mangr.corp_client_id = a.corp_client_id
            left join (
                select distinct name_ru            as city_ru,
                                tz_aggl_name_en    as city_en,
                                tz_country_name_en as country,
                                case when tz_aggl_name_en in ('Moscow','Saint-Petersburg') then tz_aggl_name_en || ' (adm)' else region_name_en end as region_name_en
                from regions_geo) c
                on geo.tz_aggl_name_ru = c.city_ru
        where
            mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
            and tech_event_instant_ddtm::date <= current_date - interval '1 day'
    ) ndd
group by
    1,2,3,4,5,6,7;




drop table if exists result;
create temp table result as
    select date,
           case
               when tariff = 'K2' then 'NDD' else tariff
               end::text as tariff,
           coalesce(b.tz_country_name_en,'Russia') as country,
           coalesce(b.region_name_en,'Moscow') as region,
           case
               when client in ('Еда - рестораны', 'Еда - ритейл', 'Лавка', 'Маркет', 'INTERCO') then 'INTERCO'
               when manager_group in ('ГПП','ГПП 1','ГПП 2') then 'Tier 1'
               when manager_group in ('ГМП','ГМП 1','ГМП 2','ГМП NDD','СНГ','Израиль') then 'Tier 2'
               when manager_group = 'Тир 3' or phoenix then 'Tier 3'
               -- заплатка от команды роста: грузовые SMB - это С2С
               when c2c_smb_b2b_flg = 'SMB' and tariff_class_code in ('cargo', 'cargocorp') then 'C2C'
               when c2c_smb_b2b_flg = 'SMB' and tariff_class_code not in ('cargo', 'cargocorp') then 'Tier 4'
               when c2c_smb_b2b_flg = 'C2C' then 'C2C'
               when manager_group = 'B2B платформа' then 'B2B Platform'
               else case when tariff_class_code in ('cargo', 'cargocorp') then 'C2C' else 'Tier 4' end
               end::text                               as tier,
           case
               when tariff = 'K2' then 'Yandex'
               when client in ('Еда - рестораны', 'Еда - ритейл', 'Лавка', 'Маркет', 'INTERCO') then 'Yandex'
               when manager_group in ('ГПП','ГПП 1','ГПП 2') then coalesce(b2b.name_en,'N/A')
               when manager_group in ('ГМП','ГМП 1','ГМП 2','ГМП NDD','СНГ','Израиль') then coalesce(b2b.name_en,'N/A')
               when manager_group = 'Тир 3' then coalesce(b2b.name_en, smb.industry,'N/A')
               -- заплатка от команды роста: грузовые SMB - это С2С
               when c2c_smb_b2b_flg = 'SMB' and tariff_class_code in ('cargo', 'cargocorp') then 'C2C'
               when c2c_smb_b2b_flg = 'SMB' and tariff_class_code not in ('cargo', 'cargocorp') then coalesce(b2b.name_en, smb.industry,'N/A')
               when c2c_smb_b2b_flg = 'C2C' then 'C2C'
               when manager_group = 'B2B платформа' then coalesce(plt.industry,'N/A')
               else case when tariff_class_code in ('cargo', 'cargocorp') then 'C2C' else coalesce(b2b.name_en, smb.industry,'N/A') end
               end::text as industry,
           case
               when manager_group = 'B2B платформа' then 'B2B Platform'
               when order_source = 'API' then case
                   when referral_source_code is not null then 'Modules'
                   else 'API'
                   end
               when order_source = 'Mobile App' then 'Go'
               else order_source
               end as channel,
           sum(deliveries)                       as deliveries,
           sum(gmv)                              as gmv,
           sum(net_inflow)                       as net_inflow
    from
        snb_delivery.data_bizdev a
        left join regions_geo b
            on a.tariff_geo_zone_code = b.tariff_zone
        left join snb_delivery.industries_dict b2b
            on b2b.name_ru = a.market_segment
        left join smb_industry_mapping smb
            on smb.user_phone_pd_id = a.user_phone_pd_id
        left join b2b_platform_industry_mapping plt
            on plt.corp_client_id = a.corp_client_id
    where
        same_or_next_day_fake in ('Same', 'Next_Pvz')
    group by
        1, 2, 3, 4, 5, 6, 7

    union all

    select date,
           'NDD' as tariff,
           coalesce(b.tz_country_name_en,'Russia') as country,
           coalesce(b.region_name_en,'Moscow') as region,
           case
               when client in ('Еда - рестораны', 'Еда - ритейл', 'Лавка', 'Маркет', 'INTERCO') then 'INTERCO'
               when manager_group in ('ГПП','ГПП 1','ГПП 2') then 'Tier 1'
               when manager_group in ('ГМП','ГМП 1','ГМП 2','ГМП NDD','СНГ','Израиль') then 'Tier 2'
               when manager_group = 'Тир 3' or phoenix then 'Tier 3'
               -- заплатка от команды роста: грузовые SMB - это С2С
               when c2c_smb_b2b_flg = 'SMB' and tariff_class_code in ('cargo', 'cargocorp') then 'C2C'
               when c2c_smb_b2b_flg = 'SMB' and tariff_class_code not in ('cargo', 'cargocorp') then 'Tier 4'
               when c2c_smb_b2b_flg = 'C2C' then 'C2C'
               when manager_group = 'B2B платформа' then 'B2B Platform'
               else case when tariff_class_code in ('cargo', 'cargocorp') then 'C2C' else 'Tier 4' end
               end as tier,
           'Yandex' as industry,
           'API' as channel,
           sum(0) as deliveries,
           sum(gmv) as gmv,
           sum(net_inflow) as net_inflow

    from
        snb_delivery.data_bizdev a
        left join regions_geo b
            on a.tariff_geo_zone_code = b.tariff_zone
    where
        same_or_next_day_fake = 'Next'
    group by
        1, 2, 3, 4, 5, 6, 7

    union all

    select
        date,
        tariff,
        country,
        region,
        tier,
        industry,
        channel,
        deliveries,
        gmv,
        net_inflow
    from ndd_market_lavka

    union all

    select
        date,
        tariff,
        country,
        region,
        tier,
        industry,
        channel,
        deliveries,
        gmv,
        net_inflow
    from ndd_deliveries
;

drop table if exists snb_delivery.data_growth_olap;
create table snb_delivery.data_growth_olap as
select
        date,
        tariff,
        country,
        tier,
        region,
        industry,
        channel,
        sum(deliveries) as deliveries,
        sum(gmv) as gmv,
        sum(net_inflow) as net_inflow
from result
where date <> current_date
group by 1,2,3,4,5,6,7;


grant select on snb_delivery.data_growth_olap to public;

comment on table snb_delivery.data_growth_olap is 'OLAP-куб для Growth. LOGDATA-1583';
