import pandas as pd
import numpy as np
from business_models import hahn, greenplum
import sys
import datetime
from datetime import date, timedelta


# In[2]:


start_date = str(datetime.datetime.today().date() + datetime.timedelta(-30)) # included
print(start_date)


# In[3]:


df = hahn("""

use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$totals =
(
    select
        dt,
        cast(sum(cast(amount as Double) * 1.0 * b.rate) as Int) as expenses
    from
        range(`//home/taxi/production/export/tlog/expenses`,"2020-07-01") as a
        inner join `//home/taxi-dwh/dds/dim_currency_rate` as b
            on substring(a.invoice_date,0,10) == b.`date`
            and a.currency == b.source_cur
    where
        detailed_product = 'subsidy_booking_geo_guarantee'
        and Yson::ConvertToString(payload.rule_db_id) not in
        (
            '5f61e71221c192841c010bd1', '5f61e74321c192841c091675',
            '5f61caf121c192841c4eab61', '5f61e4e821c192841ca477b4',
            '5eedb9658fe28d5ce47f3d7d', '5f9c2351c106bd04fd90a5a5',
            '5f9c25afc106bd04fdfea280', '5f8d6b20c106bd04fd15b346',
            '5f71e15f21c192841c51bc23'
        )
        and Yson::ConvertToString(payload.nearest_zone) != 'oslo'
        and b.target_cur == 'RUB'
    group by
        DateTime::Format("%Y-%m-%d")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(invoice_date)), "Europe/Moscow")) as dt
);

$cargo_subs =
(
    select 
        dt,
        cast(sum(cast(amount as Double) * 1.0 * b.rate) as Int) as expenses_cargo
    from
        range(`//home/taxi/production/export/tlog/expenses`,"2020-07-01") as a
        inner join `//home/taxi-dwh/dds/dim_currency_rate` as b
            on substring(a.invoice_date,0,10) == b.`date`
            and a.currency == b.source_cur
    where
        detailed_product = 'subsidy_booking_geo_guarantee'
        and Yson::ConvertToString(payload.rule_db_id) in
            (
                '5f11b5998fe28d5ce446ae20', '5f1ebdb18fe28d5ce4938244',
                '5f3bb4cc8fe28d5ce4ef0678', '5f4792b821c192841ccf6e33',
                '5f3ba47b8fe28d5ce438d4d1', '5f3b9cf78fe28d5ce4fc8d9f',
                '5f3b9f098fe28d5ce4536aac', '5f3ba0548fe28d5ce489e1e8',
                '5f3ba5598fe28d5ce45d3a20', '5f3ba37f8fe28d5ce40fd879',
                '5f44e8d121c192841c84b3fb', '5f6c672121c192841c608679',
                '5f8d9b3ac106bd04fd4573ac'
            )
            and Yson::ConvertToString(payload.nearest_zone) != 'oslo'
            and b.target_cur == 'RUB'
    group by
        DateTime::Format("%Y-%m-%d")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(invoice_date)), "Europe/Moscow")) as dt
);

select
    a.dt as dt,
    expenses,
    (expenses_cargo) ?? 0 as expenses_cargo,
    ((expenses) ?? 0) - ((expenses_cargo) ?? 0) as express_courier_expenses
from
    $totals as a
    left join $cargo_subs as b on a.dt = b.dt
order by
    dt;

""")


# In[4]:


greenplum("""
delete 
from snb_delivery.data_geosubs
""")


# In[5]:


greenplum.write(dataframe=df, table_name='snb_delivery.data_geosubs', if_exists='append')


# In[6]:


print("Table snb_delivery.data_geosubs was updated successfully")
