drop table if exists ndd_market_lavka;
create temporary table ndd_market_lavka as
with a as
(
    select msk_delivered_dttm::date as day,
           count(distinct market_order_id) filter (where confirmed_flg) as deliveries
    from snb_delivery.dash_k2
    where pickup_or_lavka = 'lavka'
    group by 1
    union all
    select
        msk_delivered_dttm::date as day,
        count(distinct market_order_id) filter(where confirmed_flg) as deliveries
    from snb_delivery.dash_ts
    group by 1
)

select
    day,
    sum(deliveries) as deliveries
from a
where day < date_trunc('day',current_date)
group by 1
;




drop table if exists ndd_deliveries;
CREATE TEMP TABLE ndd_deliveries as
select
    first_day as day,
    count (distinct request_id) as deliveries
from
    (
        select distinct
            request_id,
            corp_client_id,
            coalesce(delivery_country, 'Россия') as country,
            coalesce(delivery_locality, 'Москва') as city,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from
            snb_delivery.logdata_ndd_requests_datamart
        where
            mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
            and tech_event_instant_ddtm::date <= current_date - interval '1 day'
    ) ndd
group by
    1;



drop table if exists raw;
create temp table raw as (
        select tariff_class_code as order_tariff,
               case when business = 'B2B' then True else False end as corp_order_flg,
               coalesce(case when client like 'Еда%' then 'Еда' else client end,'Other') as client,
               same_or_next_day,
               same_or_next_day_fake,
               date as day,
               domestic_int as country,
               sum(deliveries) as trips,
               sum(gmv) as gmv,
               sum(net_inflow) as net_inflow
        from
            snb_delivery.data_bizdev
        GROUP BY 1, 2, 3, 4, 5, 6, 7
    );


drop table if exists base;
create temporary table base as
SELECT
    order_tariff,
    corp_order_flg,
    country,
    case
        when corp_order_flg = True and order_tariff in ('cargo', 'cargocorp') then 'Cargo, B2B'
        when corp_order_flg = True and order_tariff in ('express','ubernight') then 'Delivery, B2B'
        when corp_order_flg = True and order_tariff = 'courier' then 'Courier, B2B'
        when corp_order_flg = False and order_tariff in ('cargo', 'cargocorp') then 'Cargo, B2C'
        when corp_order_flg = False and order_tariff in ('express','ubernight') then 'Delivery, B2C'
        when corp_order_flg = False and order_tariff = 'courier' then 'Courier, B2C'
        else 'Other'
        end as business,
    day,
    client,
    same_or_next_day,
    same_or_next_day_fake,
    unnest(array ['trips', 'gmv', 'net_inflow']) as parameter,
    unnest(array [trips, gmv, net_inflow]) as value
FROM raw;



drop table if exists express_courier_cargo;
create temporary table express_courier_cargo as
select
    day,
    sum(gmv) filter (where order_tariff in ('express', 'courier', 'ubernight')) as gmv_express_courier,
    sum(gmv) filter (where order_tariff in ('cargo', 'cargocorp')) as gmv_cargo
from raw
group by 1;



drop table if exists gmv_share;
create temporary table gmv_share as
select
    b.day,
    order_tariff,
    corp_order_flg,
    b.country,
    same_or_next_day,
    same_or_next_day_fake,
    client,
    business,
    parameter,
    case
        when order_tariff in ('cargo', 'cargocorp')
            then coalesce(value, 0) * 1.0 / coalesce(ec.gmv_cargo, 1)
        when order_tariff in ('express', 'courier', 'ubernight')
            then coalesce(value, 0) * 1.0 / coalesce(ec.gmv_express_courier, 1)
        else 0
        end as gmv_share
from
    base as b
    left join express_courier_cargo as ec on b.day = ec.day
where
    parameter = 'gmv';



drop table if exists eda_gmv_share;
create temporary table eda_gmv_share as
select
    order_tariff,
    a.day,
    country,
    same_or_next_day,
    same_or_next_day_fake,
    client,
    sum(a.gmv) as gmv_tariff,
    sum(a.gmv)::float/sum(b.gmv) as eda_gmv_share
from
    raw a
    inner join (select day, sum(gmv) as gmv from raw where client = 'Еда' group by 1) b
        on a.day = b.day
where client = 'Еда'
GROUP BY 1, 2, 3, 4, 5, 6;




drop table if exists data_fact;
create temporary table data_fact as

    select
        b.*,
        gmv_share,
        eda_gmv_share,
        case
            when b.order_tariff in ('cargo', 'cargocorp') and b.parameter = 'net_inflow'
            then coalesce(value, 0) - gmv_share * 1.0 * coalesce(e.expenses_cargo, 0)
            when b.order_tariff in ('express', 'courier', 'ubernight') and b.parameter = 'net_inflow'
            then coalesce(value, 0) - gmv_share * 1.0 * coalesce(e.express_courier_expenses, 0)
                - coalesce(eda_gmv_share, 0) * 1.0 * coalesce(eda_exp.expenses_rub::integer, 0)
            else 0
            end as net_inflow_correct
    from
        base as b
        left join snb_delivery.data_geosubs as e
            on b.day = e.dt::date
        left join snb_delivery.data_eda_expenses as eda_exp
            on b.day = eda_exp.day::date
        left join gmv_share as g
            on b.day = g.day
            and b.order_tariff = g.order_tariff
            and b.business = g.business
            and b.client = g.client
            and b.country = g.country
            and b.same_or_next_day = g.same_or_next_day
        left join eda_gmv_share as eda_gmv
            on b.day = eda_gmv.day
            and b.order_tariff = eda_gmv.order_tariff
            and b.country = eda_gmv.country
            and b.client = 'Еда'
            and b.client = eda_gmv.client
            and b.same_or_next_day = eda_gmv.same_or_next_day
;



drop table if exists correction_1;
create temporary table correction_1 as
select
    order_tariff,
    country,
    corp_order_flg,
    business,
    client,
    same_or_next_day,
    same_or_next_day_fake,
    day,
    parameter,
    case
        when parameter = 'net_inflow'
        then net_inflow_correct
        else value
        end as value
from
    data_fact;


drop table if exists day_data;
create temporary table day_data as (

    select
        order_tariff,
        country,
        corp_order_flg,
        business,
        client,
        same_or_next_day,
        day,
        parameter,
        sum(value) as value
    from
        correction_1
    where
        same_or_next_day_fake in ('Same', 'Next_Pvz')
    group by
        1, 2, 3, 4, 5, 6, 7, 8

    union all

    select
        'Other' as order_tariff,
        'Россия' as country,
        True as corp_order_flg,
        'Delivery, B2B' as business,
        'Market' as client,
        'Next' as same_or_next_day,
        day,
        unnest(array ['trips', 'gmv', 'net_inflow']) as parameter,
        unnest(array [deliveries, 0, 0]) as value
    from
        ndd_market_lavka

    union all

    select
        'Other' as order_tariff,
        'Россия' as country,
        True as corp_order_flg,
        'Delivery, B2B' as business,
        'Other' as client,
        'Next' as same_or_next_day,
        day::date as day,
        unnest(array ['trips', 'gmv', 'net_inflow']) as parameter,
        unnest(array [deliveries, 0, 0]) as value
    from ndd_deliveries

    union all

    select
        'Other' as order_tariff,
        'Россия' as country,
        True as corp_order_flg,
        'Delivery, B2B' as business,
        'Other' as client,
        'Next' as same_or_next_day,
        day,
        parameter,
        case
        when parameter = 'trips' then 0 else sum (value) end as value
    from
        correction_1
    where
        same_or_next_day_fake = 'Next'
    group by
        1, 2, 3, 4, 5, 6, 7, 8
);


drop table if exists snb_delivery.dash_bizdev_plan_fact;
create table snb_delivery.dash_bizdev_plan_fact as

-- truncate snb_delivery.dash_bizdev_plan_fact;
-- insert into snb_delivery.dash_bizdev_plan_fact

select
    business,
    unnest(array[
        date_trunc('week', day)::date,
        date_trunc('month', day)::date
        ]) as date,
    parameter,
    unnest(array['week','month']) as scale,
    same_or_next_day,
    client,
    country,
    'OP00001'                     as region_id,
    sum(coalesce(value, 0))       as value
from day_data
group by 1, 2, 3, 4, 5, 6, 7, 8;


-- grant select, insert, delete, update, truncate, references
--     on snb_delivery.dash_bizdev_plan_fact
--     to analyst, "robot-log-analytics";
