drop table if exists ndd_market_lavka;
create temporary table ndd_market_lavka as

select day, sum(deliveries) as deliveries
from (
         select msk_delivered_dttm::date                                     as day,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_k2
         where pickup_or_lavka = 'lavka'
         group by 1

         union all

         select msk_delivered_dttm::date                                     as day,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_ts
         group by 1
     ) as a
group by 1;



drop table if exists ndd_deliveries;
CREATE TEMP TABLE ndd_deliveries as
select
    first_day as day,
    count (distinct request_id) as deliveries
from
    (
        select distinct
            request_id,
            corp_client_id,
            coalesce(delivery_country, 'Россия') as country,
            coalesce(delivery_locality, 'Москва') as city,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from
            snb_delivery.logdata_ndd_requests_datamart
        where
            mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
            and tech_event_instant_ddtm::date <= current_date - interval '1 day'
    ) ndd
group by
    1;



drop table if exists base;
create temp table base as (
        select
            date as day,
            c2c_smb_b2b_flg,
            case
                when tariff = 'SDD' then 'SDD'
                when tariff = 'K2' then 'K2'
                when tariff_class_code in ('cargo', 'cargocorp') then 'Cargo'
                when tariff_class_code in ('courier','express','ubernight') then 'Delivery'
                end as tariff,
            case
                when client like 'Еда%' then 'Еда'
                when client = 'Лавка' then 'Лавка'
                when client = 'Маркет' then 'Маркет'
                else 'Other' end as client,
            same_or_next_day,
            same_or_next_day_fake,
            country,
            sum(deliveries) as deliveries,
            sum(gmv) as gmv,
            sum(gmv) filter (where tariff_class_code in ('express', 'courier', 'ubernight')) as gmv_express,
            sum(gmv) filter (where tariff_class_code in ('cargo', 'cargocorp')) as gmv_cargo,
            sum(gmv) filter (where client like 'Еда%') as gmv_eda,
            sum(commissions) as commissions,
            sum(subsidies) as subsidies,
            sum(decoupling) as decoupling,
            sum(net_inflow) as net_inflow
        from
            snb_delivery.data_bizdev
        GROUP BY 1, 2, 3, 4, 5, 6, 7
    );



drop table if exists base_share;
create temporary table base_share as
select
    *,
    gmv_express*1.0/sum(gmv_express) over (partition by day) as gmv_express_share,
    gmv_cargo*1.0/sum(gmv_cargo) over (partition by day) as gmv_cargo_share,
    gmv_eda*1.0/sum(gmv_eda) over (partition by day) as gmv_eda_share
from
    base;




drop table if exists data_fact;
create temporary table data_fact as

    select
        b.day,
        c2c_smb_b2b_flg,
        tariff,
        client,
        same_or_next_day,
        same_or_next_day_fake,
        country,
        deliveries,
        gmv,
        gmv_express,
        gmv_cargo,
        gmv_eda,
        commissions,
        gmv_express_share,
        gmv_cargo_share,
        gmv_eda_share,
        b.subsidies
            + coalesce(gmv_cargo_share,0) * 1.0 * coalesce(geo.expenses_cargo, 0)
            + coalesce(gmv_express_share,0) * 1.0 * coalesce(geo.express_courier_expenses, 0)
            as subsidies,
        b.decoupling
            - coalesce(gmv_eda_share,0) * 1.0 * coalesce(eda_exp.expenses_rub::integer, 0)
            as decoupling,
        b.net_inflow
            - coalesce(gmv_cargo_share,0) * 1.0 * coalesce(geo.expenses_cargo, 0)
            - coalesce(gmv_express_share,0) * 1.0 * coalesce(geo.express_courier_expenses, 0)
            - coalesce(gmv_eda_share,0) * 1.0 * coalesce(eda_exp.expenses_rub::integer, 0)
            as net_inflow
    from
        base_share as b
        left join snb_delivery.data_geosubs as geo
            on b.day = geo.dt::date
        left join snb_delivery.data_eda_expenses as eda_exp
            on b.day = eda_exp.day::date
;




drop table if exists day_data;
create temporary table day_data as (

    select
        case
            when tariff = 'K2' then 'K2'
            when same_or_next_day = 'Next' then 'NDD'
            else tariff
        end as tariff,
        country,
        c2c_smb_b2b_flg,
        client,
        same_or_next_day,
        day,
        unnest(array ['deliveries', 'gmv', 'commissions', 'subsidies', 'decoupling', 'net_inflow']) as parameter,
        unnest(array [sum(deliveries), sum(gmv), sum(commissions), sum(subsidies), sum(decoupling), sum(net_inflow)]) as value
    from
        data_fact
    where
        same_or_next_day_fake in ('Same', 'Next_Pvz')
    group by
        1, 2, 3, 4, 5, 6

    union all

    select
        'K2' as tariff,
        'Россия' as country,
        'B2B' as c2c_smb_b2b_flg,
        'Other' as client,
        'Next' as same_or_next_day,
        day,
        unnest(array ['deliveries', 'gmv', 'commissions', 'subsidies', 'decoupling', 'net_inflow']) as parameter,
        unnest(array [0, sum(gmv), sum(commissions), sum(subsidies), sum(decoupling), sum(net_inflow)]) as value
--         parameter,
--         case when parameter = 'deliveries' then 0 else sum (value) end as value
    from
        data_fact
    where
        same_or_next_day_fake = 'Next'
    group by
        1, 2, 3, 4, 5, 6

    union all

    select
        'K2' as tariff,
        'Россия' as country,
        'B2B' as c2c_smb_b2b_flg,
        'Маркет' as client,
        'Next' as same_or_next_day,
        day,
        unnest(array ['deliveries', 'gmv', 'commissions', 'subsidies', 'decoupling', 'net_inflow']) as parameter,
        unnest(array [deliveries, 0, 0, 0, 0, 0]) as value
    from
        ndd_market_lavka

    union all

    select
        'NDD' as tariff,
        'Россия' as country,
        'B2B' as c2c_smb_b2b_flg,
        'Other' as client,
        'Next' as same_or_next_day,
        day::date as day,
        unnest(array ['deliveries', 'gmv', 'commissions', 'subsidies', 'decoupling', 'net_inflow']) as parameter,
        unnest(array [deliveries, 0, 0, 0, 0, 0]) as value
    from ndd_deliveries

);


drop table if exists snb_delivery.dash_bizdev_plan_fact_smb_source;
create table snb_delivery.dash_bizdev_plan_fact_smb_source as

select
    day as date,
    c2c_smb_b2b_flg as business,
    tariff,
    parameter as metric,
    same_or_next_day,
    client,
    country,
    sum(coalesce(value, 0)) as value
from day_data
where day < current_date
group by 1, 2, 3, 4, 5, 6, 7;

grant select
    on snb_delivery.dash_bizdev_plan_fact_smb_source
    to public;

grant insert, delete, update, truncate, references
    on snb_delivery.dash_bizdev_plan_fact_smb_source
    to "robot-log-analytics","robot-delivery-bi";

comment on table snb_delivery.dash_bizdev_plan_fact_smb_source is 'Данные факта для деша Plan-Fact. LOGDATA-909';



drop table if exists snb_delivery.dash_bizdev_plan_fact_smb;
create table snb_delivery.dash_bizdev_plan_fact_smb as

with a as (
    SELECT unnest(array ['day','week','month']) as scale,
           unnest(array [
               coalesce(fact.date, plan_2022.date, amb_2022.date, plan_202204.date, amb_202204.date, plan_202207.date, amb_202207.date)::date,
               coalesce(
                   date_trunc('week', fact.date),
                   date_trunc('week', plan_2022.date),
                   date_trunc('week', amb_2022.date),
                   date_trunc('week', plan_202204.date),
                   date_trunc('week', amb_202204.date),
                   date_trunc('week', plan_202207.date),
                   date_trunc('week', amb_202207.date)
                   )::date,
               coalesce(
                   date_trunc('month', fact.date),
                   date_trunc('month', plan_2022.date),
                   date_trunc('month', amb_2022.date),
                   date_trunc('month', plan_202204.date),
                   date_trunc('month', amb_202204.date),
                   date_trunc('month', plan_202207.date),
                   date_trunc('month', amb_202207.date)
                   )::date
               ]) as date,
           coalesce(
               fact.country,
               plan_2022.country,
               amb_2022.country,
               plan_202204.country,
               amb_202204.country,
               plan_202207.country,
               amb_202207.country) as country,
           coalesce(
               fact.tariff,
               plan_2022.tariff,
               amb_2022.tariff,
               plan_202204.tariff,
               amb_202204.tariff,
               plan_202207.tariff,
               amb_202207.tariff) as tariff,
           coalesce(
               fact.business,
               plan_2022.business,
               amb_2022.business,
               plan_202204.business,
               amb_202204.business,
               plan_202207.business,
               amb_202207.business)as business,
           coalesce(
               fact.same_or_next_day,
               plan_2022.same_or_next_day,
               amb_2022.same_or_next_day,
               plan_202204.same_or_next_day,
               amb_202204.same_or_next_day,
               plan_202207.same_or_next_day,
               amb_202207.same_or_next_day) as same_or_next_day,
           coalesce(
               fact.client,
               plan_2022.client,
               amb_2022.client,
               plan_202204.client,
               amb_202204.client,
               plan_202207.client,
               amb_202207.client) as client,
           coalesce(
               fact.metric,
               plan_2022.metric,
               amb_2022.metric,
               plan_202204.metric,
               amb_202204.metric,
               plan_202207.metric,
               amb_202207.metric) as metric,
           sum(coalesce(fact.value,0.0))::float                               as value_fact,
           sum(coalesce(plan_2022.value, 0.0))::float                         as value_plan_2022,
           sum(coalesce(amb_2022.value, 0.0))::float                          as value_amb_2022,
           sum(coalesce(plan_202204.value, 0.0))::float                       as value_plan_202204,
           sum(coalesce(amb_202204.value, 0.0))::float                        as value_amb_202204,
           sum(coalesce(plan_202207.value, 0.0))::float                       as value_plan_202207,
           sum(coalesce(amb_202207.value, 0.0))::float                        as value_amb_202207
    FROM
        snb_delivery.dash_bizdev_plan_fact_smb_source as fact
        full join snb_delivery.plans_budget_2022_v2 as plan_2022
            using (date, business, tariff, same_or_next_day, metric, country, client)
        full join snb_delivery.plans_ambition_2022_v2 as amb_2022
            using (date, business, tariff, same_or_next_day, metric, country, client)
        full join snb_delivery.plans_bud_202204 as plan_202204
            using (date, business, tariff, same_or_next_day, metric, country, client)
        full join snb_delivery.plans_amb_202204_int as amb_202204
            using (date, business, tariff, same_or_next_day, metric, country, client)
        full join snb_delivery.plans_bud_202207 as plan_202207
            using (date, business, tariff, same_or_next_day, metric, country, client)
        full join snb_delivery.plans_amb_202207 as amb_202207
            using (date, business, tariff, same_or_next_day, metric, country, client)
    group by 1, 2, 3, 4, 5, 6, 7, 8
)
select
    *,
    lag(value_fact) over (partition by scale, business, same_or_next_day, metric, country, tariff, client order by date) as value_fact_prev,
    max(case when abs(value_fact) > 0.00001 then date else '2000-01-01' end) OVER (partition by scale)::date as max_act_date
from a
where date is not null and country is not null;


update snb_delivery.dash_bizdev_plan_fact_smb as a
set value_fact_prev = 0
where scale = 'day';

update snb_delivery.dash_bizdev_plan_fact_smb as a
set value_fact_prev = coalesce(b.value_fact,0)
from snb_delivery.dash_bizdev_plan_fact_smb as b
where
    a.scale = 'day'
    and a.scale = b.scale
    and a.business = b.business
    and a.same_or_next_day = b.same_or_next_day
    and a.metric = b.metric
    and a.country = b.country
    and a.tariff = b.tariff
    and a.client = b.client
    and a.date = b.date + 7;


grant select on snb_delivery.dash_bizdev_plan_fact_smb to public;

grant insert, delete, update, truncate, references
    on snb_delivery.dash_bizdev_plan_fact_smb
    to "robot-log-analytics","robot-delivery-bi";

comment on table snb_delivery.dash_bizdev_plan_fact_smb is 'Данные факта и планов для деша Plan-Fact. LOGDATA-909';

