use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;

$REQUIREMENT = 'thermobag_covid';
$DT_START = '2021-06-26';
$ORDER_PROC = '//home/taxi-delivery/analytics/production/order_proc';
$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$CANDIDATES = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
$INSERT_PATH = '//home/taxi-delivery/analytics/production/bizdev/termobags/thermobag_orders';

$order_proc = (
    select order_id, user_fraud_flg
    from range($ORDER_PROC, substring($DT_START, 0, 7))
);

$orders = (
    select
        order_id,
        utc_order_dttm,
        moscow_order_dttm,
        tariff_zone,
        order_tariff,
        order_source,
        application_platform,
        corp_order_flg,
        success_order_flg,
        fraud_order_flg,
        order_cost,
        user_cost,
        order_source_lat,
        order_source_lon,
        order_cancel_reason,
        order_comment,
        plan_travel_distance_km,
        plan_travel_time_min,
        driver_search_duration_sec,
        driver_tech_search_duration_sec,
        expired_order_flg,
        driver_id is not null as driver_found_flg,
        status,
        taxi_status,
        balance_rate,
    from range($DM_ORDER, substring($DT_START, 0, 7))
    where Yson::Contains(order_requirements, $REQUIREMENT)
        and moscow_order_dt >= $DT_START

);

$order_cand = (
    select
      order_id,
      avg(candidate_seq) as candidate_seq_avg,
      count(executor_profile_sk) as candidates_cnt,
      avg(time_to_dest_sec) as time_to_dest_sec,
      avg(router_dist_m) as router_dist_m,
      count_if(rejected_reason_code='manual') as manual_cancel_cnt,
      count_if(rejected_reason_code='autocancel') as autocancel_cancel_cnt,
      count_if(rejected_reason_code='seenimpossible') as seenimpossible_cancel_cnt,
      count_if(utc_finished_dttm is not null) as finished_cnt,
      min(utc_offered_dttm) as utc_offered_dttm_min,
    from range($CANDIDATES, substring($DT_START, 0, 7) || '-01')
    group by order_id
);

$orders_w_fraud = (
    select *
    from $orders AS ord
    left join $order_proc AS op
    on ord.order_id == op.order_id
);

$orders_w_candidates = (
    select *
    from $orders_w_fraud AS owf
    left join $order_cand AS oc
    on owf.order_id == oc.order_id
);

-- $order_stats = (
--     select
--         tariff_zone, order_tariff, order_source, application_platform, corp_order_flg,
--         count(*) as order_cnt,
--         count_if(success_order_flg) as trip_cnt,
--         count_if(success_order_flg)/cast(count(*) as float) as CR,
--         max(utc_order_dttm) as last_utc_order_dttm,
--         min(utc_order_dttm) as first_utc_order_dttm,
--     from $orders_w_candidates
--     where user_fraud_flg = false or user_fraud_flg is null
--     group by tariff_zone, order_tariff, order_source, application_platform, corp_order_flg
-- );

insert into $INSERT_PATH with truncate
select * from $orders_w_candidates
where user_fraud_flg = false or user_fraud_flg is null
order by moscow_order_dttm ASC;

--select * from $order_stats;

select
    utc_order_dttm,
    application_platform,
    corp_order_flg,
    order_id,
    order_source,
    success_order_flg,
    order_tariff,
    tariff_zone
from $orders_w_candidates;
