use hahn;
PRAGMA yt.TmpFolder='//home/taxi-delivery/tmp';

$CLAIMS_POINTS = '//home/taxi/production/replica/postgres/cargo_claims/claim_points';
$CLAIMS = '//home/taxi-delivery/analytics/production/cargo/b2b/claims_merge/b2b_claims_w_clones';

insert into `//home/taxi-delivery/analytics/production/cargo/b2b/deliverability` with truncate
select c.utc_order_dt as utc_order_dt
  , c.corp_client_id as corp_client_id
  , c.corp_client_name as corp_client_name
  , coalesce(SUM_IF(1, cp.visit_status = 'visited' and cp.type='destination'),0) as points_visited
  , coalesce(SUM_IF(1, cp.type='destination'),0) as points_total
  , 1.0*coalesce(SUM_IF(1, cp.visit_status = 'visited' and cp.type='destination'),0)/coalesce(SUM_IF(1, cp.type='destination'),0) as cr
from $CLAIMS as c 
left join $CLAIMS_POINTS as cp on c.claim_id=cp.claim_id
group by c.utc_order_dt
  , c.corp_client_id
  , c.corp_client_name;
  
