/*
    Автор: @ikhomyanin

    Использование: 
    Скрипт используется для подсчета выплат исполнителям на last mile Маркета,
    которые предоставлены Грузовым. Мы им сначала платим в рамках заказа Такси, а потом 
    доплачиваем до тарифа Маркета

    Тикет: LOGDATA-774
*/

use hahn;
pragma SimpleColumns;

$today = CurrentUtcDate();
$start_of_week = DateTime::MakeDate(DateTime::StartOfWeek($today));

$date_from = cast($start_of_week - 7*Interval('P1D') as String);
$date_to = cast($start_of_week - Interval('P1D') as String); -- включительно

-- ====================================================================================================================
-- ИЛИ ВЫБЕРИТЕ ДАТЫ, ЗА КОТОРЫЕ НУЖЕН ОТЧЕТ
-- $date_from = '2021-11-08';
-- $date_to = '2021-11-14'; -- включительно
-- ====================================================================================================================


-- НИЖЕ УЖЕ НИЧЕГО НЕ МЕНЯЕМ
-- ====================================================================================================================
-- Кусок скрипта, где собирается витрина заказов на данных Доставки
$DM_DELIVERIES = '//home/taxi-delivery/analytics/production/dm_deliveries';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$PDA_DRIVERS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_drivers';

$SAVE_TO = '//home/taxi-delivery/analytics/production/cargo/b2b/market_payments/' || $date_from || '_' || $date_to;

$MARKET_ID = 'dca7971b1b62480cbb9441f165e73080';

$START_DATE = $date_from;
$END_DATE = $date_to; -- включительно

$dm_order_start = substring($START_DATE, 0, 7);
$dm_order_end = substring($END_DATE, 0, 7);

$fct_order_start = $dm_order_start || '-01';
$fct_order_end = $dm_order_end || '-01';

$getType = ($ysonReq) -> {
    $type = IF(Yson::Contains($ysonReq, "cargo_type"), Yson::ConvertToString($ysonReq.cargo_type), "NONE");

    $typeIntStr = IF(Yson::Contains($ysonReq, "cargo_type_int"), Yson::ConvertToString($ysonReq.cargo_type_int), "0");
    $typeInt = CAST($typeIntStr as Int32);
    
    $type = IF(
        $type = "NONE",
        IF($typeInt=1,
            "VAN",
            IF($typeInt=2,
                "MEDIUM",
                IF($typeInt=3,
                    "LARGE",
                    "NONE"
                )
            )
        ),
        IF($type='van',
            "VAN",
            IF($type='lcv_m',
                "MEDIUM",
                IF($type='lcv_l',
                    "LARGE",
                    "NONE"
                )
            )
        ),
    );
    RETURN $type
};

$claims = (
    select claim_uuid_id
        , some(corp_client_id) as any_corp_client_id
        , some(claim_id) as any_claim_id
        , some(taxi_order_id) as any_order_id
        , some(taxi_tariff_class_code) as tariff_class
        , cast(some(claim_performer_found_utc_dttm) as String) as any_claim_performer_found_utc_dttm
        , substring(cast(some(claim_performer_found_utc_dttm) as String), 0, 10) as any_claim_performer_found_utc_dt
        --  , cast(cast(any(claim_delivered_utc_dttm) as Datetime) as String) as any_claim_delivered_utc_dttm
        --  , cast(cast(any(claim_delivered_finish_utc_dttm) as Datetime) as String) as any_claim_delivered_finish_utc_dttm
        --  , count(claim_destination_address_details) as points_cnt
        , count_if(claim_dst_visit_status='visited') as dst_visited_points_cnt
        from $DM_DELIVERIES
        where corp_client_id = $MARKET_ID
            and taxi_tariff_class_code in ('cargocorp', 'cargo')
            and claim_performer_found_utc_dttm is not null
            and substring(cast(claim_performer_found_utc_dttm as String), 0, 10) between $START_DATE and $END_DATE
        group by claim_uuid_id
);

$delivery = (
    select mc.any_claim_performer_found_utc_dt as utc_dt
        , o.agglomeration_node_id as agglomeration_node_id
        , $getType(dm.order_requirements) as car_size
    ------------------------------------------------------------------------------------------------------------------------
    -- ИДЕНТИФИКАТОРЫ ВОДИТЕЛЕЙ НА ЛЮБОЙ ВКУС И ЦВЕТ
        , dm.driver_id as driver_id-- CLID_UUID
        , dm.db_id as db_id-- Идентификатор парка в Таксометре (db_id)
        , dm.park_id as park_id --CLID 
        , dm.unique_driver_id as unique_driver_id
    ------------------------------------------------------------------------------------------------------------------------
    -- ФИО
        , d.first_name as first_name
        , d.last_name as last_name
        , d.middle_name as middle_name
        , d.last_name || ' ' || d.first_name || ' ' || d.middle_name as full_name
        , d.last_name || ' ' || d.first_name as courier_name
    ------------------------------------------------------------------------------------------------------------------------
        , o.order_id as order_id
        , o.travel_time_mnt as travel_time_mnt
        , dm.travel_distance_km ?? o.transporting_distance_plan_km as travel_distance_km_corr
        , (
            o.driver_cost 

            + o.subsidy_value 
            + o.holded_subsidy_value 
            + o.subsidy_commission_discount_value 

            - o.order_commission_w_discount_wo_vat_value 
            - o.order_commission_vat_value 
            - o.shift_commission_w_vat_value 
            - o.call_center_commission_w_vat_value 
            - o.childchair_rent_w_vat_value 
            - o.voucher_commission_wo_vat_value 
            - o.holded_subsidy_commission_value 
            - o.subsidy_commission_value 
            - o.driver_fix_comission_wo_vat_amt 
            - o.driver_fix_comission_for_fraud_wo_vat_amt 
            - o.acquiring_commission_value 
            - o.rebate_w_vat_value 
            - o.agency_commission_w_vat_value
        ) * o.currency_rate as driver_income_rub
    ------------------------------------------------------------------------------------------------------------------------
    -- ЕСЛИ ХОЧЕТСЯ УЗНАТЬ, ЧТО ВНУТРИ РАСЧЕТА driver_income_rub,
    -- ТО НУЖНО РАСКОММЕНТИРОВАТЬ СТРОКИ НИЖЕ (УБРАТЬ "--")
        -- , o.driver_cost as driver_cost 
        -- , o.subsidy_value as subsidy_value
        -- , o.holded_subsidy_value as holded_subsidy_value
        -- , o.subsidy_commission_discount_value as subsidy_commission_discount_value
        -- , o.order_commission_w_discount_wo_vat_value as order_commission_w_discount_wo_vat_value
        -- , o.order_commission_vat_value as order_commission_vat_value
        -- , o.shift_commission_w_vat_value as shift_commission_w_vat_value
        -- , o.call_center_commission_w_vat_value as call_center_commission_w_vat_value
        -- , o.childchair_rent_w_vat_value as childchair_rent_w_vat_value
        -- , o.voucher_commission_wo_vat_value as voucher_commission_wo_vat_value
        -- , o.holded_subsidy_commission_value as holded_subsidy_commission_value
        -- , o.subsidy_commission_value as subsidy_commission_value
        -- , o.driver_fix_comission_wo_vat_amt as driver_fix_comission_wo_vat_amt
        -- , o.driver_fix_comission_for_fraud_wo_vat_amt as driver_fix_comission_for_fraud_wo_vat_amt
        -- , o.acquiring_commission_value as acquiring_commission_value
        -- , o.rebate_w_vat_value as rebate_w_vat_value
        -- , o.agency_commission_w_vat_value as agency_commission_w_vat_value
        -- , o.currency_rate as currency_rate

    -- А ТУТ ДОЛЯ НДС И КОМИСИИ В driver_cost, КОТОРЫЙ ВИДЕЛ ИСПОЛНИТЕЛЬ
        -- , o.order_commission_w_discount_wo_vat_value / o.driver_cost as comission
        -- , o.order_commission_vat_value / o.order_commission_w_discount_wo_vat_value as wat
    ------------------------------------------------------------------------------------------------------------------------    

    ------------------------------------------------------------------------------------------------------------------------    
    --  СЕНС ЧЕКИ, ЧТО НУЖНЫЕ ЗАКАЗЫ ВЫБРАНЫ
        , dm.utc_order_dt as utc_order_dt
        , o.tariff_class_code as tariff_class_code
        , o.tariff_geo_zone_code as tariff_geo_zone_code
    ------------------------------------------------------------------------------------------------------------------------    
    from $claims as mc 
    left join range($FCT_ORDER, $fct_order_start, $fct_order_end) as o on mc.any_order_id=o.order_id
    left join range($DM_ORDER, $dm_order_start, $dm_order_end) as dm on o.order_id=dm.order_id
    left join $PDA_DRIVERS as d on d.park_id=dm.db_id and d.driver_id=String::SplitToList(dm.driver_id, '_')[1]
); 
-- ====================================================================================================================


-- ====================================================================================================================
-- Кусок, где обрабатываю данные Маркета и джойню их с данными Доставки
$SHIFTS = '//home/market/users/kashaev-yi/taxi/user_shifts';

-- Москва
$FIRST_ZONE = [            
    "МК Дзержинский КГТ"	
    , "МК Тарный КГТ"	
    , "МК Дзержинский"	
    , "МК Тарный"	
    , "МК Тарный 2 волна"	
    , "МК Север"	
    , "МК Запад"	
    , "МК Дзержинский  2 волна"	
    , "МК Юг"
    , "МК Томилино"
];

-- СПБ
$SECOND_ZONE = [
    "МК Питер"	
    , "МК Питер Верхняя"	
    , "МК Питер Верхняя 2"
    , "МК Питер Бугры 2 волна"
    , "МК Питер Шушары 2 волна"
    , "МК Питер 2"
];

-- Другие регионы
$THIRD_ZONE = [
    "МК Краснодар"	
    , "МК Новосибирск "	
    , "МК Самара"	
    , "МК Новороссийск"	
    , "МК Ростов"
    , "МК Рязань"
    , "МК Пенза"
    , "МК Уфа"
    , "МК Нижний Новгород"
    , "МК Саратов"
    , "МК Астрахань"
    , "МК Волгоград"
    , "МК Казань"
    , "МК Курск"
    , "МК Ярославль"
    , "МК Иваново"
];

$TARIFF = Yson::ParseJson(@@
{
    "1" : {
        "До 150км": {
            "98-100%": {
                "Минималка": 6050,
                "От 11 мультизаказов": 550
            },
            "95-97%": {
                "Минималка": 5500,
                "От 11 мультизаказов": 500
            },
            "91-94%": {
                "Минималка": 5000,
                "От 11 мультизаказов": 455
            },
            "до 90%": {
                "Минималка": 4583,
                "От 11 мультизаказов": 417
            }
        },
        "До 250км": {
            "98-100%": {
                "Минималка": 7260,
                "От 11 мультизаказов": 572
            },
            "95-97%": {
                "Минималка": 6600,
                "От 11 мультизаказов": 520
            },
            "91-94%": {
                "Минималка": 6000,
                "От 11 мультизаказов": 473
            },
            "до 90%": {
                "Минималка": 5500,
                "От 11 мультизаказов": 433
            }
        },
        "До 350км": {
            "98-100%": {
                "Минималка": 8470,
                "От 11 мультизаказов": 594
            },
            "95-97%": {
                "Минималка": 7700,
                "От 11 мультизаказов": 540
            },
            "91-94%": {
                "Минималка": 7000,
                "От 11 мультизаказов": 491
            },
            "до 90%": {
                "Минималка": 6417,
                "От 11 мультизаказов": 450
            }
        },
        "До 450км": {
            "98-100%": {
                "Минималка": 9680,
                "От 11 мультизаказов": 616
            },
            "95-97%": {
                "Минималка": 8800,
                "От 11 мультизаказов": 560
            },
            "91-94%": {
                "Минималка": 8000,
                "От 11 мультизаказов": 509
            },
            "до 90%": {
                "Минималка": 7333,
                "От 11 мультизаказов": 467
            }
        },
        "До 550км": {
            "98-100%": {
                "Минималка": 10890,
                "От 11 мультизаказов": 638
            },
            "95-97%": {
                "Минималка": 9900,
                "От 11 мультизаказов": 580
            },
            "91-94%": {
                "Минималка": 9000,
                "От 11 мультизаказов": 527
            },
            "до 90%": {
                "Минималка": 8250,
                "От 11 мультизаказов": 483
            }
        },
        "До 650км": {
            "98-100%": {
                "Минималка": 12100,
                "От 11 мультизаказов": 660
            },
            "95-97%": {
                "Минималка": 11000,
                "От 11 мультизаказов": 600
            },
            "91-94%": {
                "Минималка": 10000,
                "От 11 мультизаказов": 545
            },
            "до 90%": {
                "Минималка": 9167,
                "От 11 мультизаказов": 500
            }
        },
        "от 651км": {
            "98-100%": {
                "Минималка": 13310,
                "От 11 мультизаказов": 682
            },
            "95-97%": {
                "Минималка": 12100,
                "От 11 мультизаказов": 620
            },
            "91-94%": {
                "Минималка": 11000,
                "От 11 мультизаказов": 564
            },
            "до 90%": {
                "Минималка": 10083,
                "От 11 мультизаказов": 517
            }
        }
    },
    "2": {
        "До 150км": {
            "98-100%": {
                "Минималка": 5830,
                "От 11 мультизаказов": 528
            },
            "95-97%": {
                "Минималка": 5300,
                "От 11 мультизаказов": 480
            },
            "91-94%": {
                "Минималка": 4818,
                "От 11 мультизаказов": 436
            },
            "до 90%": {
                "Минималка": 4417,
                "От 11 мультизаказов": 400
            }
        },
        "До 250км": {
            "98-100%": {
                "Минималка": 7040,
                "От 11 мультизаказов": 550
            },
            "95-97%": {
                "Минималка": 6400,
                "От 11 мультизаказов": 500
            },
            "91-94%": {
                "Минималка": 5818,
                "От 11 мультизаказов": 455
            },
            "до 90%": {
                "Минималка": 5333,
                "От 11 мультизаказов": 417
            }
        },
        "До 350км": {
            "98-100%": {
                "Минималка": 8250,
                "От 11 мультизаказов": 572
            },
            "95-97%": {
                "Минималка": 7500,
                "От 11 мультизаказов": 520
            },
            "91-94%": {
                "Минималка": 6818,
                "От 11 мультизаказов": 473
            },
            "до 90%": {
                "Минималка": 6250,
                "От 11 мультизаказов": 433
            }
        },
        "До 450км": {
            "98-100%": {
                "Минималка": 9460,
                "От 11 мультизаказов": 594
            },
            "95-97%": {
                "Минималка": 8600,
                "От 11 мультизаказов": 540
            },
            "91-94%": {
                "Минималка": 7818,
                "От 11 мультизаказов": 491
            },
            "до 90%": {
                "Минималка": 7167,
                "От 11 мультизаказов": 450
            }
        },
        "До 550км": {
            "98-100%": {
                "Минималка": 10670,
                "От 11 мультизаказов": 616
            },
            "95-97%": {
                "Минималка": 9700,
                "От 11 мультизаказов": 560
            },
            "91-94%": {
                "Минималка": 8818,
                "От 11 мультизаказов": 509
            },
            "до 90%": {
                "Минималка": 8083,
                "От 11 мультизаказов": 467
            }
        },
        "До 650км": {
            "98-100%": {
                "Минималка": 11880,
                "От 11 мультизаказов": 638
            },
            "95-97%": {
                "Минималка": 10800,
                "От 11 мультизаказов": 580
            },
            "91-94%": {
                "Минималка": 9818,
                "От 11 мультизаказов": 527
            },
            "до 90%": {
                "Минималка": 9000,
                "От 11 мультизаказов": 483
            }
        },
        "от 651км": {
            "98-100%": {
                "Минималка": 13090,
                "От 11 мультизаказов": 660
            },
            "95-97%": {
                "Минималка": 11900,
                "От 11 мультизаказов": 600
            },
            "91-94%": {
                "Минималка": 10818,
                "От 11 мультизаказов": 545
            },
            "до 90%": {
                "Минималка": 9917,
                "От 11 мультизаказов": 500
            }
        }
    },
    "3": {
        "До 150км": {
            "98-100%": {
                "Минималка": 5610,
                "От 11 мультизаказов": 506
            },
            "95-97%": {
                "Минималка": 5100,
                "От 11 мультизаказов": 460
            },
            "91-94%": {
                "Минималка": 4636,
                "От 11 мультизаказов": 418
            },
            "до 90%": {
                "Минималка": 4250,
                "От 11 мультизаказов": 383
            }
        },
        "До 250км": {
            "98-100%": {
                "Минималка": 6820,
                "От 11 мультизаказов": 528
            },
            "95-97%": {
                "Минималка": 6200,
                "От 11 мультизаказов": 480
            },
            "91-94%": {
                "Минималка": 5636,
                "От 11 мультизаказов": 436
            },
            "до 90%": {
                "Минималка": 5167,
                "От 11 мультизаказов": 400
            }
        },
        "До 350км": {
            "98-100%": {
                "Минималка": 8030,
                "От 11 мультизаказов": 550
            },
            "95-97%": {
                "Минималка": 7300,
                "От 11 мультизаказов": 500
            },
            "91-94%": {
                "Минималка": 6636,
                "От 11 мультизаказов": 455
            },
            "до 90%": {
                "Минималка": 6083,
                "От 11 мультизаказов": 417
            }
        },
        "До 450км": {
            "98-100%": {
                "Минималка": 9240,
                "От 11 мультизаказов": 572
            },
            "95-97%": {
                "Минималка": 8400,
                "От 11 мультизаказов": 520
            },
            "91-94%": {
                "Минималка": 7636,
                "От 11 мультизаказов": 473
            },
            "до 90%": {
                "Минималка": 7000,
                "От 11 мультизаказов": 433
            }
        },
        "До 550км": {
            "98-100%": {
                "Минималка": 10450,
                "От 11 мультизаказов": 594
            },
            "95-97%": {
                "Минималка": 9500,
                "От 11 мультизаказов": 540
            },
            "91-94%": {
                "Минималка": 8636,
                "От 11 мультизаказов": 491
            },
            "до 90%": {
                "Минималка": 7917,
                "От 11 мультизаказов": 450
            }
        },
        "До 650км": {
            "98-100%": {
                "Минималка": 11660,
                "От 11 мультизаказов": 616
            },
            "95-97%": {
                "Минималка": 10600,
                "От 11 мультизаказов": 560
            },
            "91-94%": {
                "Минималка": 9636,
                "От 11 мультизаказов": 509
            },
            "до 90%": {
                "Минималка": 8833,
                "От 11 мультизаказов": 467
            }
        },
        "от 651км": {
            "98-100%": {
                "Минималка": 12870,
                "От 11 мультизаказов": 638
            },
            "95-97%": {
                "Минималка": 11700,
                "От 11 мультизаказов": 580
            },
            "91-94%": {
                "Минималка": 10636,
                "От 11 мультизаказов": 527
            },
            "до 90%": {
                "Минималка": 9750,
                "От 11 мультизаказов": 483
            }
        }
    }
}
@@);

$convert_name = ($name) -> {
    $list = ListMap(
        String::SplitToList($name, ' '),
        ($x) -> { RETURN if($x != "", $x, null) }
    );

    $new_name = String::JoinFromList($list, " ");

    $answer = case
        when $new_name == "Никитин Александ" then "Никитин Александр"
        when $new_name == "Кузнецов Александр Ген" then "Кузнецов Александр"
        when $new_name == "Пихтелёв Илья" then "Пихтелев Илья"
        else $new_name
    end;

    return $answer;
};

$extract_zone = ($sorting_center) -> {
    $zone = case
        when $sorting_center in $FIRST_ZONE then "1"
        when $sorting_center in $SECOND_ZONE then "2"
        when $sorting_center in $THIRD_ZONE then "3"
        else "UNKNOWN SORTING CENTER"
    end;
    return $zone;
};

$extract_distance_group = ($distance) -> {
    $group = case 
        when $distance > 0 and $distance <= 150 then "До 150км"
        when $distance > 150 and $distance <= 250 then "До 250км"
        when $distance > 250 and $distance <= 350 then "До 350км"
        when $distance > 350 and $distance <= 450 then "До 450км"
        when $distance > 450 and $distance <= 550 then "До 550км"
        when $distance > 550 and $distance <= 650 then "До 650км"
        when $distance > 650 then "от 651км"
        else "DISTANCE ERROR"
    end;
    return $group;
};

$extract_rdd_group = ($raw_rdd) -> {
    $rdd = 1.0*cast(($raw_rdd * 100) as Int64) / 100;
    $group = case
        when $rdd >= 0.98 then "98-100%"
        when $rdd < 0.98 and $rdd >= 0.95 then "95-97%"
        when $rdd < 0.95 and $rdd >= 0.91 then "91-94%"
        when $rdd < 0.91 then "до 90%"
        else "RDD ERROR"
    end;
    return $group;
};

$extract_min_group = ($multipoints) -> {
    $group = case
        when $multipoints >= 11 then "От 11 мультизаказов"
        when $multipoints > 0 and $multipoints < 11 then "Минималка"
        else "MIN GROUP ERROR"
    end;
    return $group;
};

$calculate_salary = ($zone, $distance_group, $rdd_group, $multipoints) -> {
    $min_salary = Yson::ConvertToInt64($TARIFF[$zone][$distance_group][$rdd_group]["Минималка"]);
    $points_salary = Yson::ConvertToInt64($TARIFF[$zone][$distance_group][$rdd_group]["От 11 мультизаказов"]) * $multipoints;

    $salary = case
        when $min_salary >= $points_salary then $min_salary
        when $min_salary < $points_salary then $points_salary
        else -1
    end;

    return $salary;
};

insert into $SAVE_TO WITH TRUNCATE 
select s.shift_date as shift_date
    , s.user_shift_id as user_shift_id
    , s.courier_name as courier_name_market
    , s.id_cou as id_cou
    , s.dostavlyaemost as dostavlyaemost
    , s.sorting_center_name as sorting_center_name
    , s.transitDistance_billing as transitDistance_billing
    , s.total_multi_billing as total_multi_billing
    , $calculate_salary($extract_zone(s.sorting_center_name), 
                        $extract_distance_group(s.transitDistance_billing), 
                        $extract_rdd_group(s.dostavlyaemost), 
                        s.total_multi_billing) as salary
    , $extract_zone(s.sorting_center_name) as zone
    , $extract_distance_group(s.transitDistance_billing) as distance_group
    , $extract_rdd_group(s.dostavlyaemost) as rdd_group 
    , $extract_min_group(s.total_multi_billing) as min_group
    , s.lockerCount_billing as lockerCount_billing
    , s.multiOrdersStandardCount_billing as multiOrdersStandardCount_billing
    , s.pvzCount_billing as pvzCount_billing
    , s.transport_type as transport_type
    , d.*
from $SHIFTS as s
left join $delivery as d on $convert_name(s.courier_name)=$convert_name(d.courier_name) and s.shift_date=d.utc_dt
where 1=1
    and s.total_multi_billing is not null
    and s.shift_date between $date_from and $date_to;