import os

from datetime import datetime

import pandas as pd

import smtplib
from os.path import basename
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.utils import COMMASPACE

import yt.wrapper as yt

def current_utc_timestamp():
    return datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')

def send_mail(send_from, send_to, 
              subject, text, files=None,
              server="outbound-relay.yandex.net"):
    assert isinstance(send_to, list)

    msg = MIMEMultipart()
    msg['From'] = send_from
    msg['To'] = COMMASPACE.join(send_to)
    msg['Subject'] = subject

    msg.attach(MIMEText(text))

    for f in files or []:
        with open(f, "rb") as fil:
            part = MIMEApplication(
                fil.read(),
                Name=basename(f)
            )
        part['Content-Disposition'] = 'attachment; filename="%s"' % basename(f)
        msg.attach(part)


    smtp = smtplib.SMTP(server)
    smtp.sendmail(send_from, send_to, msg.as_string())
    smtp.close()
    
def main():
    print(f'{current_utc_timestamp()} - START')
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    DATA_PATH = '//home/taxi-delivery/analytics/production/cargo/ban_hammer/clients_fraud/recent_data'

    #print(f'{current_utc_timestamp()} - Importing data')
    
    df = pd.DataFrame(list(yt.read_table(DATA_PATH)))   
    df.to_excel('suspicious_activity.xlsx', index=False)
    
        
    FROM_EMAIL = 'noreply@yandex-team.ru'

    TO_EMAILS = [
    'dashayevdak@yandex-team.ru',
    'sofalogvinova@yandex-team.ru',
    'nosachev@yandex-team.ru',
    'elizaveta-fed@yandex-team.ru',
    'ilyaotter@yandex-team.ru',
    'ebarkasov@yandex-team.ru',
    'kravtsovdv@yandex-team.ru',
    'badolgan@yandex-team.ru',
    'rekol@yandex-team.ru'
    ]
    SUBJECT = 'Подозрительная активность в C2C грузовом'
    TEXT = 'Данные за последние 3 часа. Предыдущие выгрузки можно посмотреть в табличке://home/taxi-delivery/analytics/production/cargo/ban_hammer/clients_fraud/information_for_all_time. По вопросам обращаться к @dashayevdak.'

    send_mail(send_from = FROM_EMAIL,
        send_to = TO_EMAILS,
        subject = SUBJECT,
        text = TEXT,
        files = ['suspicious_activity.xlsx'])
        
    
    #print(f'{current_utc_timestamp()} - Creating excel')
   
    
    #print(f'{current_utc_timestamp()} - Sending email')
    
    
    #print(f'{current_utc_timestamp()} - Email sent')
    #print(f'{current_utc_timestamp()} - END')
    
if __name__ == '__main__':
    main()

    
