use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$ORDER = '//home/taxi-dwh/ods/dbprocessing/order';

$SAVE_TO_HISTORY = '//home/taxi-delivery/analytics/production/cargo/ban_hammer/clients_fraud/information_for_all_time';
$SAVE_RECENT_DATA = '//home/taxi-delivery/analytics/production/cargo/ban_hammer/clients_fraud/recent_data';


$critical_value = 10;

$today = CurrentUtcDate();
$date_time = CurrentUtcDatetime();
$today_str = cast($today as string);
$week_ago = cast($today - Interval('P7D') as string);
$days92ago = cast($today - Interval('P60D') as string);
$start_month = substring($days92ago,0,7) || '-01';



$orders = 
    (select 
        user_phone_id
        , user_phone_pd_id
        , tariff_class_id
        , MAX_by(order_id, utc_order_created_dttm) as last_order_id
        , MIN_BY(order_id, utc_order_created_dttm) as first_order_in_3_months
        , min(utc_order_created_dttm) as utc_first_order_in_3_months_dttm
        , max(utc_order_created_dttm) as utc_last_order_created_dttm
        , count(order_id) as cnt_orders 
        , count_if(user_status = 'cancelled') as cnt_user_cancelled
        , count_if(user_status = 'finished' and driver_status = 'complete') as cnt_success
    from range($ORDER, $start_month)
    where 1=1 
        and tariff_class_id in ('cargo', 'courier', 'express')
    group by 
        user_phone_id
        , user_phone_pd_id
        , tariff_class_id
    ); 


$info = (
    select 
        user_phone_id
        , user_phone_pd_id
        , tariff_class_id
        , last_order_id
        , first_order_in_3_months
        , utc_first_order_in_3_months_dttm
        , utc_last_order_created_dttm
        , cnt_orders
        , cnt_user_cancelled
        , cnt_success
        , case 
            when cnt_orders = cnt_user_cancelled and cnt_orders >= $critical_value then 'У пользотвателя все заказы за сегодня - отмена'
            when cnt_user_cancelled = (cnt_orders - cnt_success) and cnt_orders >= $critical_value and cnt_user_cancelled > 0 then 'За исключением успешных заказов, у пользователя все остальные заказы - отмена по его инициации за сегодня'
            else 'не потенциальный фрод'
        end as fraud_info       
    from $orders 
    where 1=1
    and substring(utc_last_order_created_dttm, 0, 10) = $today_str
    and substring(utc_first_order_in_3_months_dttm,0,10) >= $week_ago

    );    


INSERT INTO $SAVE_RECENT_DATA WITH TRUNCATE 
select 
    i.* 
    , $date_time as utc_updated
from $info as i
where fraud_info != 'не потенциальный фрод'
and cnt_user_cancelled >=10
and cnt_success <= 1
-- order by cnt_user_cancelled desc
;


insert into $SAVE_TO_HISTORY
select 
    i.* 
    , $date_time as utc_updated
from $info as i
where fraud_info != 'не потенциальный фрод'
and cnt_user_cancelled >=10
and cnt_success <= 1
-- order by cnt_user_cancelled desc
;
