-- CARGO BAN HAMMER
-- LOGDATA-616

use hahn;

$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';

$BAN_HISTORY = '//home/taxi-delivery/analytics/production/cargo/ban_hammer/user_bans/history';
$CURRENT_BANS = '//home/taxi-delivery/analytics/production/cargo/ban_hammer/user_bans/current_bans';

$N_DAYS = 5;
$USER_CANCEL_TH = 10;
$USER_CANCEL_SHARE_TH = 0.5;

$BAN_LENGTH = 15;

$today = CurrentUtcDate();
$today_dttm = CurrentUtcDatetime();

$start_date = cast($today - $N_DAYS*Interval('P1D') as String);
$end_day = cast($today - Interval('P1D') as String);

$start_month = substring($start_date, 0, 7) || '-01';
$end_month = substring($end_day, 0, 7) || '-01';

$user_ids_to_ban = (
    select user_phone_id
        , count(order_id) as orders_cnt
        , count_if(success_order_flg) as trips_cnt
        , count_if(user_status='cancelled') as user_cancel_cnt
    from range($FCT_ORDER, $start_month, $end_month)
    where 1=1
        and not mqc_order_flg
        and not fake_order_flg
        and not corp_order_flg
        and tariff_class_code = 'cargo'
        and utc_order_created_dt between $start_date and $end_day
    group by user_phone_id
    having count_if(user_status='cancelled') > $USER_CANCEL_TH
        and 1.0 * count_if(user_status='cancelled') / count(order_id) > $USER_CANCEL_SHARE_TH
);

$already_banned = (
    select *
    from $BAN_HISTORY
    where 1=1
        and ban_end >= cast($today as String)
);

$new_bans_data = (
    select t1.*
        , cast($today as String) as ban_start
        , cast($today + ($BAN_LENGTH - 1)*Interval('P1D') as String) as ban_end
        , 'more than ' || cast($USER_CANCEL_TH as String) || ' user cancellations for past ' || cast($N_DAYS as String) || ' days' as ban_reason
        , cast($today_dttm as String) as script_exec_utc_dttm
        , $USER_CANCEL_TH as th   
        , $N_DAYS as n_days 
    from $user_ids_to_ban as t1
    where 1=1
        and t1.user_phone_id not in (
            select user_phone_id 
            from $already_banned
        )
);

INSERT INTO $BAN_HISTORY 
select * from $new_bans_data;

INSERT INTO $CURRENT_BANS WITH TRUNCATE 
select * from $already_banned
union all
select * from $new_bans_data;
