  
-- https://st.yandex-team.ru/LOGDATA-445
use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.InferSchema = '1';
PRAGMA yt.Pool = 'taxi-delivery';

$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$CANDIDATES = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$CLAIM_POINTS = '//home/delivery-dwh/ods/cargo_claims/claim_point';
$CLAIM = '//home/delivery-dwh/ods/cargo_claims/claim';
$MANUAL_DISPATCH_CLIENTS = '//home/taxi-delivery/analytics/production/cargo/operations/manual_dispatch_clients';

$SAVE_TO = '//home/taxi-delivery/analytics/production/cargo/demand/cr_datamart';

$START_MONTH = '2021-03-01';
$MONTH_SELECT_START_CP = "2021-01-01";
$start_month_alt = substring($START_MONTH, 0, 7);

$manual_dispatch_ids = (
    select corp_client_id
    from $MANUAL_DISPATCH_CLIENTS
);


$today = CurrentUtcDate();

$getLoaders = ($ysonReq) -> {
    $loaders = IF(Yson::Contains($ysonReq, "cargo_loaders"), Yson::ConvertToString($ysonReq.cargo_loaders), "0");
    RETURN CAST($loaders as Int32)
};

$getType = ($ysonReq) -> {
    $type = IF(Yson::Contains($ysonReq, "cargo_type"), Yson::ConvertToString($ysonReq.cargo_type), "NONE");

    $typeIntStr = IF(Yson::Contains($ysonReq, "cargo_type_int"), Yson::ConvertToString($ysonReq.cargo_type_int), "0");
    $typeInt = CAST($typeIntStr as Int32);
    
    $type = IF(
        $type = "NONE",
        IF($typeInt=1,
            "VAN",
            IF($typeInt=2,
                "MEDIUM",
                IF($typeInt=3,
                    "LARGE",
                    "NONE"
                )
            )
        ),
        IF($type='van',
            "VAN",
            IF($type='lcv_m',
                "MEDIUM",
                IF($type='lcv_l',
                    "LARGE",
                    "NONE"
                )
            )
        ),
    );
    RETURN $type
};

$order_cand = (
    select order_id
      , count(executor_profile_sk) as candidates_cnt
    from range($CANDIDATES, $START_MONTH)
    group by order_id
);

$orders_fraud = (
    select order_id
      , user_fraud_flg
      , taximeter_park_id || '_' || executor_profile_id as dbid_uuid
    from range($FCT_ORDER, $START_MONTH)
);

$points = (
    select 
        COUNT_IF(cp.point_type="destination" AND 
                 cp.visit_status = "visited") AS destination_multipoints
        , COUNT_IF((cp.point_type="destination" or cp.point_type="source" or cp.point_type="return") AND 
                 cp.visit_status = "visited") AS cnt_visited_multipoints
        , cp.claim_id as claim_id 
        , c.taxi_order_id as taxi_order_id
    from RANGE($CLAIM, $START_MONTH) as c
    left join RANGE($CLAIM_POINTS, $MONTH_SELECT_START_CP) as cp on c.claim_id=cp.claim_id
    where 1=1
        and c.taxi_order_id is not null 
        and c.claim_id is not null
        and cp.claim_id is not null
    group by 
        cp.claim_id
        , c.taxi_order_id
);

$orders = (
    select dm.order_id as order_id
        , dm.utc_order_dt as utc_order_dt
        , substring(dm.local_order_dttm, 0, 10) as local_order_dt
        , dm.local_order_dttm as local_order_dttm
        , dm.tariff_zone as tariff_zone
        , dm.order_tariff as order_tariff
        , dm.driver_id as driver_id
        , oc.candidates_cnt ?? 0 as candidates_cnt
        , IF(
            points.cnt_visited_multipoints IS NULL, 
            IF(dm.plan_order_destination_point_cnt>0, dm.plan_order_destination_point_cnt, 1), 
            points.cnt_visited_multipoints
        ) AS cnt_visited_points
        , IF(
            points.destination_multipoints IS NULL, 
            IF(dm.plan_order_destination_point_cnt>0, dm.plan_order_destination_point_cnt, 1), 
            points.destination_multipoints
        ) AS destination_points
        , case
            when dm.status='cancelled' then 'cancelled_by_client'
            when dm.status='finished' and dm.taxi_status='complete' then 'success'
            when dm.status='finished' and dm.taxi_status='cancelled' then 'cancelled_by_operator'
            when dm.status='finished' and dm.taxi_status='failed' then 'cancelled_by_driver'
            when dm.status='finished' and dm.taxi_status='expired' then 'expired'
            else 'not_finished_yet'
        end as human_status 
        , $getLoaders(dm.order_requirements) as loaders
        , $getType(dm.order_requirements) as car_type
        , dm.corp_order_flg as corp_order_flg
        , dm.application_platform as application_platform
        , dm.order_type as order_type
        , dm.order_cost as order_cost
        , dm.balance_rate as balance_rate
        , dm.currency_rate as currency_rate
        , geo.name_ru as name_ru
        , geo.tz_country_name_ru as tz_country_name_ru
        , geo.population_group as population_group
        , ListHead(String::SplitToList(geo.population_group, "_")) as country_group
        , ListLast(String::SplitToList(geo.population_group, "_")) as population
        , dm.user_phone_pd_id as user_phone_pd_id
        , dm.user_phone_id as user_phone_id
        , dm.corp_client_id as corp_client_id
        , dm.corp_contract_id as corp_contract_id
        , dm.corp_client_name as corp_client_name
        , op.dbid_uuid as dbid_uuid
    from range($DM_ORDER, $start_month_alt) as dm
    left join $orders_fraud as op on dm.order_id=op.order_id
    left join $order_cand as oc on oc.order_id=dm.order_id
    left join $GEO as geo on geo.tariff_zone=dm.tariff_zone
    left join $points as points on points.taxi_order_id = dm.order_id 
    where 1=1
        and not dm.fake_order_flg
        and not dm.fraud_order_flg
        and not dm.mqc_order_flg
        and (dm.order_tariff='cargo' or dm.order_tariff='cargocorp')
        and (op.user_fraud_flg = false or op.user_fraud_flg is null)
        and dm.utc_order_dt < cast($today as String)
        and substring(dm.local_order_dttm, 0, 10) < cast($today as String)
        and geo.node_type = 'agglomeration'
        and geo.root_node_id = 'br_root'
);

INSERT INTO $SAVE_TO with truncate
SELECT o.* 
    , CASE
        when o.human_status='cancelled_by_client' and o.driver_id is null then 'cancelled_by_user_before_assign'
        when o.human_status='cancelled_by_client' and o.driver_id is not null then 'cancelled_by_user_after_assign'
        when o.human_status='expired' and o.candidates_cnt > 0 then 'expired_w_cand'
        when o.human_status='expired' and o.candidates_cnt = 0 then 'expired_wo_cand'
        when o.human_status='success' then 'success'
        when o.human_status='cancelled_by_operator' then 'cancelled_by_operator'
        when o.human_status='cancelled_by_driver' then 'cancelled_by_driver'
        else 'ERROR'
        end as dash_status 
        -- New feature in LOGDATA-744
    , CASE
        when o.corp_client_id in $manual_dispatch_ids then true
        else false
        end as manual_dispatch_flg
    from $orders as o
    where o.human_status != 'not_finished_yet';
