use hahn;

$DM_ORDER = '//home/taxi-dwh/summary/dm_order';

$START_MONTH = '2021-01';

$PATH_TO_INSERT = '//home/taxi-delivery/analytics/production/cargo/demand/surge_datamart';

$getLoaders = ($ysonReq) -> {
    $loaders = IF(Yson::Contains($ysonReq, "cargo_loaders"), Yson::ConvertToString($ysonReq.cargo_loaders), "0");
    RETURN CAST($loaders as Int32)
};

$getType = ($ysonReq) -> {
    $type = IF(Yson::Contains($ysonReq, "cargo_type"), Yson::ConvertToString($ysonReq.cargo_type), "NONE");

    $typeIntStr = IF(Yson::Contains($ysonReq, "cargo_type_int"), Yson::ConvertToString($ysonReq.cargo_type_int), "0");
    $typeInt = CAST($typeIntStr as Int32);
    
    $type = IF(
        $type = "NONE",
        IF($typeInt=1,
            "VAN",
            IF($typeInt=2,
                "MEDIUM",
                IF($typeInt=3,
                    "LARGE",
                    "NONE"
                )
            )
        ),
        IF($type='van',
            "VAN",
            IF($type='lcv_m',
                "MEDIUM",
                IF($type='lcv_l',
                    "LARGE",
                    "NONE"
                )
            )
        ),
    );
    RETURN $type
};

INSERT INTO $PATH_TO_INSERT WITH TRUNCATE 
select order_id
  , utc_order_dt
  , tariff_zone
  , balance_rate
  , application_platform
  , paid_supply_flg
  , $getLoaders(order_requirements) as loaders
  , $getType(order_requirements) as car_type
from range($DM_ORDER, $START_MONTH)
where not fake_order_flg
  and not fraud_order_flg
  and not mqc_order_flg
  and order_tariff = 'cargo';