use hahn;

$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';

$START_MONTH = '2021-04';
$today = cast(CurrentUtcDate() as String);

$PARSE = DateTime::Parse('%Y-%m-%d %H:%M:%S');

$getLoaders = ($ysonReq) -> {
    $loaders = IF(Yson::Contains($ysonReq, "cargo_loaders"), Yson::ConvertToString($ysonReq.cargo_loaders), "0");
    RETURN CAST($loaders as Int32)
};

$getType = ($ysonReq) -> {
    $type = IF(Yson::Contains($ysonReq, "cargo_type"), Yson::ConvertToString($ysonReq.cargo_type), "NONE");

    $typeIntStr = IF(Yson::Contains($ysonReq, "cargo_type_int"), Yson::ConvertToString($ysonReq.cargo_type_int), "0");
    $typeInt = CAST($typeIntStr as Int32);
    
    $type = IF(
        $type = "NONE",
        IF($typeInt=1,
            "VAN",
            IF($typeInt=2,
                "MEDIUM",
                IF($typeInt=3,
                    "LARGE",
                    "NONE"
                )
            )
        ),
        IF($type='van',
            "VAN",
            IF($type='lcv_m',
                "MEDIUM",
                IF($type='lcv_l',
                    "LARGE",
                    "NONE"
                )
            )
        ),
    );
    RETURN $type
};

$geo_data = (
    select tariff_zone
      , agglomeration_node_id
      , name_ru
    from $GEO
    where root_node_id = 'br_root'
      and node_type = 'agglomeration'
);

$data = (
    select order_id
    , if(status= 'finished' and taxi_status = 'complete', 'success',
            if(status='cancelled', 'cancelled_by_user',
                if(status='finished' and taxi_status = 'cancelled', 'cancelled_by_cc',
                    if(status='finished' and taxi_status = 'failed', 'cancelled_by_driver','NOT FINISHED YET')))) as real_status
    , status
    , taxi_status
    , success_order_flg
    , user_wait_time_min
    , utc_order_dt
    , utc_order_dttm
    , utc_order_due_dttm
    , order_type
    , tariff_zone
    , 1.0*(Cast(DateTime::ToSeconds(DateTime::MakeDatetime($PARSE(utc_order_due_dttm))) - DateTime::ToSeconds(DateTime::MakeDatetime($PARSE(utc_order_dttm))) as Double) - coalesce(driver_search_duration_sec,0))/ 60 as eta
    , order_cancel_reason
    , $getLoaders(order_requirements) as loaders
    , $getType(order_requirements) as car_type
    from range($DM_ORDER, $START_MONTH)
    where not fake_order_flg
    and not fraud_order_flg
    and not mqc_order_flg
    and not corp_order_flg
    and (order_tariff = 'cargo' or order_tariff = 'cargocorp')
    and utc_order_due_dttm is not null
    and driver_id is not null
    and utc_order_dt < $today
);

insert into `//home/taxi-delivery/analytics/production/cargo/demand/orders_ta_distribution` with truncate
select d.*
  , g.name_ru as agglomeration_name
from $data as d
left join $geo_data as g on d.tariff_zone=g.tariff_zone;
