import pandas as pd
from business_models.startrek import StartrekWrapper
import os
from datetime import datetime
import smtplib
from os.path import basename
import yt.wrapper as yt

FILENAME = 'car_size_weekly.xlsx'
TICKET_ID = 'LOGDATA-963'

def current_utc_timestamp():
     return datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')

def main():
    date = datetime.utcnow().strftime('%Y-%m-%d')
    print(f'{current_utc_timestamp()} - START')
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    DATA_PATH = f'//home/taxi-delivery/analytics/production/cargo/car_sizes/{date}'

    print(f'{current_utc_timestamp()} - Importing data')
    df = pd.DataFrame(list(yt.read_table(DATA_PATH)))
    
    print(f'{current_utc_timestamp()} - Creating excel')
    df.to_excel('car_size_weekly.xlsx', index=False)
    
    print(f'Sending to {TICKET_ID}...')
    st = StartrekWrapper()
    st.comment(TICKET_ID, text='Обновленные данные по машинам без размеров с phone_pd_ids водителей', attachments=FILENAME)


if __name__ == '__main__':
    main()