use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- осталось добавить размер машины 


$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$CARS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_cars';
$DRIVERS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_drivers';
$CAR_SIZES = '//home/taxi-delivery/analytics/production/cargo/car_sizes';

$today = CurrentUtcDate();
$last_week = cast($today - Interval("P1W") as String);
$today_str = cast($today as String);

$start_month= substring($last_week, 0, 7)  || '-01';
$start_all = '2021-11-16';


$SAVE_TO_YT = '//home/taxi-delivery/analytics/production/cargo/car_sizes/' || $today_str; 

$supply = (
    select
       MAX(f_o.utc_order_due_dttm) as last_utc_line
        , f_o.executor_profile_id as executor_profile_id
        , f_o.taximeter_park_id as park_taximeter_id
        , SOME(dr.last_name || " " || dr.first_name || " " || dr.middle_name) as full_name
        , SOME(dr.car_id) as car_id
        , SOME(Yson::ConvertToStringList(dr.phone_pd_ids)) as phone_pd_ids
        , SOME(f_o.park_client_name) as park_client_name
        , some(f_o.unique_driver_id) as unique_driver_id
        , TryMember(mode(f_o.agglomeration_name_ru)[0], 'Value', null) as agglomeration_name_ru
    from range($FCT_ORDER,$start_month) as f_o
    left join $DRIVERS as dr on f_o.executor_profile_id = dr.driver_id and f_o.taximeter_park_id = dr.park_id
    where 1=1
        and not f_o.fake_order_flg
        and not f_o.mqc_order_flg
        and f_o.car_profile_id is not null
        and f_o.taximeter_park_id is not null
        and f_o.tariff_class_code = 'cargo'
        and f_o.utc_order_created_dt >= $last_week
        and f_o.utc_order_created_dt < $today_str
    group by f_o.taximeter_park_id
    , f_o.executor_profile_id   
); 

$total = (
        select 
        e.park_taximeter_id as park_id 
        , e.park_client_name as park_client_name
        , e.car_id as car_id
        , e.last_utc_line as last_utc_line
        , e.executor_profile_id as executor_profile_id
        , e.full_name as full_name
        , e.phone_pd_ids as phone_pd_ids
        , c.cargo_hold_dimensions as cargo_hold_dimensions
        , c.cargo_hold_dimensions.height as height
        , c.cargo_hold_dimensions.length as length
        , c.cargo_hold_dimensions.width as width
        , CASE 
                    WHEN (
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 180 AND 250) and 
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 380 and 601) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 180 and 250)   
                        )

                        AND NOT 
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 250) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 601) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 250)    
                        )
                    ) THEN 'LARGE'
                    WHEN (
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 250) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 601) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 250)   
                        )

                        AND NOT
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 180 AND 250) and 
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 380 and 601) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 180 and 250)  
                        )

                        AND NOT
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 90 AND 201) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 170 and 290) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 96 and 201)
                        )
                    ) THEN 'MEDIUM'
                    WHEN (
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 90 AND 201) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 170 and 290) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 96 and 201)   
                        )

                        AND NOT
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 250) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 601) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 250)
                        )
                    ) THEN 'VAN'
                    WHEN (
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 180 AND 250) and 
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 380 and 601) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 180 and 250)   
                        )

                        AND
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 250) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 601) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 250)  
                        )
                    ) THEN 'LARGE / MEDIUM'
                    WHEN (
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 250) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 601) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 250)
                        )

                        AND 
                        (
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 90 AND 201) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 170 and 290) and
                        (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 96 and 201)   
                        )
                    ) THEN 'MEDIUM / VAN'
                    ELSE 'ERROR'
                    END AS size_group
        , c.brand as brand
        , c.model as model
        , c.year as year
        , c.cargo_loaders_amount as cargo_loaders_amount
        , e.agglomeration_name_ru as agglomeration_name_ru
    from $supply as e 
    left join $CARS as c on c.car_id=e.car_id and c.park_id=e.park_taximeter_id
    where c.car_id is not null
         and c.car_id not in (
            select car_id
            from range($CAR_SIZES, $start_all, $last_week) )
    );


INSERT INTO $SAVE_TO_YT WITH TRUNCATE

select 
    park_id
    , park_client_name
    , car_id
    , last_utc_line
    , executor_profile_id 
    , full_name
    , phone_pd_ids
    , height
    , length
    , width
    , brand
    , model
    , year
    , cargo_loaders_amount
    , agglomeration_name_ru
from $total
where size_group = 'ERROR'
  
