USE hahn;

PRAGMA yson.DisableStrict;


$getDatetimeFromDttm = ($str) -> {
    $dttm = $str || IF(FIND($str, ":") IS NULL,  " 00:00:00", "");

    $parseDttm = DateTime::Parse("%Y-%m-%d %H:%M:%S");
    $dateTime = DateTime::MakeDatetime($parseDttm($dttm));
    RETURN $dateTime;
};

$getWeekFromDttm = ($dttm) -> {
    $dateTime = $getDatetimeFromDttm($dttm);
    RETURN CAST(DateTime::MakeDate(DateTime::StartOfWeek($dateTime) ) AS String);
};
$timeFn = $getWeekFromDttm;
$dtStart = '2021-08-02';
$orders = "//home/taxi-delivery/analytics/production/cargo/demand/cr_datamart";

SELECT  
    week,
    tariff_zone,
    car_type,
    COUNT_IF(dash_status = 'success') AS trips,
    1.*COUNT_IF(dash_status = 'success')/COUNT(1) AS CR,

    1.*COUNT_IF(dash_status = 'expired_wo_cand')/COUNT(1) AS ER_WOD,
    1.*COUNT_IF(dash_status = 'expired_w_cand')/COUNT(1) AS ER_WD,
    1.*COUNT_IF(dash_status = 'cancelled_by_user_before_assign')/COUNT(1) AS UCR_BA,
    1.*COUNT_IF(dash_status = 'cancelled_by_user_after_assign')/COUNT(1) AS UCR_AA,
    1.*COUNT_IF(dash_status = 'cancelled_by_operator' OR dash_status = 'cancelled_by_driver')/COUNT(1) AS OCR,

    IF((0.75 - 1.*COUNT_IF(dash_status = 'success')/COUNT(1))*COUNT(1)>0, (0.75 - 1.*COUNT_IF(dash_status = 'success')/COUNT(1))*COUNT(1), 0) AS failed_orders,

    COUNT(DISTINCT driver_id) AS drivers

FROM $orders
WHERE
    utc_order_dt >= $dtStart
GROUP BY $timeFn(utc_order_dt) AS week, tariff_zone, car_type
ORDER BY week, tariff_zone, car_type
;