
USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.pool = "taxi-delivery";


$CLAIM_SEGMENT_POINT_STATUS_LOG_OLD = '//home/delivery-dwh/ods/cargo_claims/claim_segment_point_status_log';
$CLAIM_SEGMENT_POINT_OLD = '//home/delivery-dwh/ods/cargo_claims/claim_segment_point';
$CLAIM_OLD = '//home/delivery-dwh/ods/cargo_claims/claim';
$CLAIM_POINT_OLD = '//home/delivery-dwh/ods/cargo_claims/claim_point';
$POINT_OLD = '//home/delivery-dwh/ods/cargo_claims/point';
$CLAIM_STATUS_LOG_OLD = '//home/delivery-dwh/ods/cargo_claims/claim_status_log';


$SAVE_TO = '//home/taxi-delivery/analytics/production/cargo/operations/grs_daily_statistics';

$today = CurrentUtcDate();
$yesterday = $today - Interval('P1D');
$MONTH_START = substring(cast($yesterday as string), 0, 7) || '-01'; 
-- $datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$date_format = DateTime::Format("%H:%M:%S");

$CLAIM_CORP_CLIENT_ID =  (
    "7d41e3375d4f49dfbde17a5c2d17ec4f" -- глобус
    , "aa3cf958e6c442e18b4ce6df811f6f14" -- Яндекс. Услуги
    , "3c0b9cd4d6474436ade3bb614d60cfed" -- Элементари
    , "10e0550610254cdab46c28cda5efff15" -- Яндекс. Лавка
    , "8a555ec30ffd4ce3b37bbf8323bf59fb" -- Симплвайн
    , "5be3b5d0d66b472cb2dc14ef9a61dfbc" -- СДЭК
    , "dca7971b1b62480cbb9441f165e73080" -- Яндекс.Маркет
    , "51e94d3e17e04eb491761731440713d7" -- Эркафарм
    , "bfcafe053244447185178870cdbd6a60" -- ПониЭкспресс
);

$claim_segment_point = (
    select 
        cspsl.claim_segment_point_id as claim_segment_point_id
        --, cspsl.new_point_status as new_point_status
        , some( if (cspsl.new_point_status = 'visited', cspsl.utc_created_dttm, null)) as time_visited
        , some( if (cspsl.new_point_status = 'arrived', cspsl.utc_created_dttm, null)) as time_arrived
        , some( if (cspsl.new_point_status = 'pending', cspsl.utc_created_dttm, null)) as time_pending
        , some( if (cspsl.new_point_status = 'skipped', cspsl.utc_created_dttm, null)) as time_skipped
        --, cspsl.utc_created_dttm as time_updare_point_status
        , cspo.claim_point_id as claim_point_id
    from range($CLAIM_SEGMENT_POINT_STATUS_LOG_OLD, $MONTH_START) as cspsl 
    left join range($CLAIM_SEGMENT_POINT_OLD, $MONTH_START) as cspo on cspsl.claim_segment_point_id = cspo.claim_segment_point_id
    group by  cspsl.claim_segment_point_id
       -- , cspsl.new_point_status
        , cspo.claim_point_id
        --, cspsl.utc_created_dttm
);

$claim = (
    select 
        claim_id
        , corp_client_id
        , cargo_ref_id
    from range($CLAIM_OLD, $MONTH_START)
    where corp_client_id in $CLAIM_CORP_CLIENT_ID
);

$claim_point = (
    select 
        claim_id
        , point_id
        , visit_status
        , claim_point_id
        , point_type
        , utc_last_status_change_dttm as utc_created_dttm_cp
    from range($CLAIM_POINT_OLD, $MONTH_START)
    -- where visit_status = 'visited'
);

$point = (
    select 
       point_id
       , point_full_address
       -- , time_interval_from_dttm
       -- , time_interval_to_dttm
       , point_comment
    from range($POINT_OLD, $MONTH_START)
);

$claim_status_log = (
    select 
        claim_id
        , some( if (new_claim_status = 'pickup_arrived', utc_created_dttm, null)) as time_arrived_at_storage
        , some( if (new_claim_status = 'performer_found', utc_created_dttm, null)) as time_performer_found
        , some( if (new_claim_status = 'performer_lookup', utc_created_dttm, null)) as time_performer_lookup
       -- , utc_created_dttm as time_arrived_at_storage
        -- , new_claim_status -- человек приехал на склад 
    from range($CLAIM_STATUS_LOG_OLD, $MONTH_START)
    group by claim_id
);

$total_hell = (
    select
        * 
    FROM $claim as c
    left join $claim_point as cp on c.claim_id = cp.claim_id
    left join $claim_status_log as cst on c.claim_id = cst.claim_id
    left join $point as p on cp.point_id = p.point_id
    left join $claim_segment_point as csp on cp.claim_point_id = csp.claim_point_id

);

$table_whith_diff = (
    SELECT 
        cargo_ref_id
        , corp_client_id
        , claim_id
        , claim_point_id
        , point_comment
        -- , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_interval_from_dttm)), 'Europe/Moscow')) as time_interval_from_dttm
        -- , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_interval_to_dttm)), 'Europe/Moscow')) as time_interval_to_dttm 
        , point_full_address
        , point_id
        , point_type
        , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_performer_lookup)), 'Europe/Moscow')) as time_performer_lookup
        , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_performer_found)), 'Europe/Moscow')) as time_performer_found
        , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_arrived_at_storage)), 'Europe/Moscow')) as time_arrived_at_storage
        , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_arrived)), 'Europe/Moscow')) as arrival_time_at_point
        , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_visited)), 'Europe/Moscow')) as visit_time_at_point
        , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_skipped)), 'Europe/Moscow')) as time_skipped 

    from $total_hell
    where substring(cast(time_arrived_at_storage as string), 0, 10) = substring(cast($yesterday as string), 0, 10)
    -- order by cargo_ref_id
    --     , claim_point_id
    --     , time_arrived_at_storage
);

 INSERT INTO $SAVE_TO with truncate 

select 
    cargo_ref_id
    , corp_client_id
    , claim_id
    , claim_point_id
    , point_comment
    -- , time_interval_from_dttm
    -- , time_interval_to_dttm
    , point_full_address
    , point_id
    , point_type
    , time_performer_lookup
    , time_performer_found
    , $date_format(DateTime::FromSeconds(cast(cast((DateTime::MakeDatetime(DateTime::ParseIso8601(time_performer_found))) - (DateTime::MakeDatetime(DateTime::ParseIso8601(time_performer_lookup))) as int) / (1000000) as Uint32)))  
    as driver_appointment_time
    , arrival_time_at_point
    , visit_time_at_point
    , $date_format(DateTime::FromSeconds(cast(cast((DateTime::MakeDatetime(DateTime::ParseIso8601(visit_time_at_point))) - (DateTime::MakeDatetime(DateTime::ParseIso8601(arrival_time_at_point))) as int) / (1000000) as Uint32))) as time_spent_at_the_point
    , time_skipped
    from $table_whith_diff 
    order by
        corp_client_id 
        , cargo_ref_id
        , claim_point_id
        , time_performer_lookup
