import os

from datetime import datetime

import pandas as pd

import smtplib
from os.path import basename
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.utils import COMMASPACE

import yt.wrapper as yt

def current_utc_timestamp():
    return datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')

def send_mail(send_from, send_to, 
              subject, text, files=None,
              server="outbound-relay.yandex.net"):
    assert isinstance(send_to, list)

    msg = MIMEMultipart()
    msg['From'] = send_from
    msg['To'] = COMMASPACE.join(send_to)
    msg['Subject'] = subject

    msg.attach(MIMEText(text))

    for f in files or []:
        with open(f, "rb") as fil:
            part = MIMEApplication(
                fil.read(),
                Name=basename(f)
            )
        part['Content-Disposition'] = 'attachment; filename="%s"' % basename(f)
        msg.attach(part)


    smtp = smtplib.SMTP(server)
    smtp.sendmail(send_from, send_to, msg.as_string())
    smtp.close()
    
def main():
    CLAIM_CORP_CLIENT_ID =  {
    "7d41e3375d4f49dfbde17a5c2d17ec4f" : "Globus"
    , "a1912966c73c437b93d3ae5022146616" : "Yandex.Usligi"
    , "3c0b9cd4d6474436ade3bb614d60cfed" : "Elementari"
    , "10e0550610254cdab46c28cda5efff15" : "Yandex.Lavka"
    , "8a555ec30ffd4ce3b37bbf8323bf59fb" : "SimpleWine"
    , "5be3b5d0d66b472cb2dc14ef9a61dfbc" : "CDEK"
    , "dca7971b1b62480cbb9441f165e73080" : "Yandex.Market"
    , "51e94d3e17e04eb491761731440713d7" : "Erkafarm"
    , "bfcafe053244447185178870cdbd6a60" : "PonyExpress"
    }
    print(f'{current_utc_timestamp()} - START')
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    DATA_PATH = '//home/taxi-delivery/analytics/production/cargo/operations/grs_daily_statistics'

    #print(f'{current_utc_timestamp()} - Importing data')
    
    FILES_TO_SEND = []
    
    for corp_id in CLAIM_CORP_CLIENT_ID.keys():
        df = pd.DataFrame(list(yt.read_table(DATA_PATH)))
        corp_client = df[df['corp_client_id'] == corp_id]
        corp_client.to_excel(f'grs_daily_statistics_{CLAIM_CORP_CLIENT_ID[corp_id]}.xlsx', index=False)
        FILES_TO_SEND.append(f'grs_daily_statistics_{CLAIM_CORP_CLIENT_ID[corp_id]}.xlsx')
        
    FROM_EMAIL = 'noreply@yandex-team.ru'

    TO_EMAILS = [
    'eroyan@yandex-team.ru',
    'isherstoboev@yandex-team.ru',
    'ekkzy@yandex-team.ru',
    'kistyarev1@yandex-team.ru',
    'ikhomyanin@yandex-team.ru',
    'dashayevdak@yandex-team.ru',
    'nikonovfedor@yandex-team.ru',
    'anngrig@yandex-team.ru'
    ]
    SUBJECT = 'ГРС: Стастика по партнерам'
    TEXT = 'Статистика за вчера. По вопросам обращаться к @dashayevdak.'

    send_mail(send_from = FROM_EMAIL,
        send_to = TO_EMAILS,
        subject = SUBJECT,
        text = TEXT,
        files = FILES_TO_SEND)
        
    
    #print(f'{current_utc_timestamp()} - Creating excel')
   
    
    #print(f'{current_utc_timestamp()} - Sending email')
    
    
    #print(f'{current_utc_timestamp()} - Email sent')
    #print(f'{current_utc_timestamp()} - END')
    
if __name__ == '__main__':
    main()
