USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$CLAIM_SEGMENT_POINT_STATUS_LOG_OLD = '//home/delivery-dwh/ods/cargo_claims/claim_segment_point_status_log';
$CLAIM_SEGMENT_POINT_OLD = '//home/delivery-dwh/ods/cargo_claims/claim_segment_point';
$CLAIM_OLD = '//home/delivery-dwh/ods/cargo_claims/claim';
$CLAIM_POINT_OLD = '//home/delivery-dwh/ods/cargo_claims/claim_point';
$POINT_OLD = '//home/delivery-dwh/ods/cargo_claims/point';
$CLAIM_STATUS_LOG_OLD = '//home/delivery-dwh/ods/cargo_claims/claim_status_log';
$TAXI_PERFORMER_INFO = '//home/delivery-dwh/ods/cargo_claims/taxi_performer_info';

$SAVE_TO = '//home/taxi-delivery/analytics/production/cargo/operations/lateness';

$today = CurrentUtcDate();
$yesterday = $today - Interval('P1D');
$yesterday_str = cast($yesterday as string);
$MONTH_START = substring(cast($yesterday as string), 0, 7) || '-01'; 
$date_format = DateTime::Format("%H:%M:%S");



$CLAIM_CORP_CLIENT_ID = [
    '4fd4380db61442849d3ddb91cd9867f5' -- NDD
    , '7d41e3375d4f49dfbde17a5c2d17ec4f' -- Глобус
    , '10e0550610254cdab46c28cda5efff15' -- Лавка 
    , '1f86abc44e5e44b8890b533434008d2e' -- Маркет
    , 'aa3cf958e6c442e18b4ce6df811f6f14' -- Яндекс.Услуги
    , '3c0b9cd4d6474436ade3bb614d60cfed' -- Элементари
    , '19392efec6b34084bd846d5dd76f32ad' -- SimpleWine
];

$claim_segment_point = (
    select 
        cspsl.claim_segment_point_id as claim_segment_point_id
        , some( if (cspsl.new_point_status = 'visited', cspsl.utc_created_dttm, null)) as time_visited
        , some( if (cspsl.new_point_status = 'arrived', cspsl.utc_created_dttm, null)) as time_arrived
        , some( if (cspsl.new_point_status = 'pending', cspsl.utc_created_dttm, null)) as time_pending
        , some( if (cspsl.new_point_status = 'skipped', cspsl.utc_created_dttm, null)) as time_skipped
        , cspo.claim_point_id as claim_point_id
    from range($CLAIM_SEGMENT_POINT_STATUS_LOG_OLD, $MONTH_START) as cspsl 
    left join range($CLAIM_SEGMENT_POINT_OLD, $MONTH_START) as cspo on cspsl.claim_segment_point_id = cspo.claim_segment_point_id
    group by  cspsl.claim_segment_point_id
        , cspo.claim_point_id
);

$claim = (
    select 
        claim_id
        , corp_client_id
        , cargo_ref_id
        , utc_due_dttm
    from range($CLAIM_OLD, $MONTH_START)
    where corp_client_id in $CLAIM_CORP_CLIENT_ID
);

$claim_point = (
    select 
        claim_id
        , point_id
        , visit_status
        , claim_point_id
        , point_type
        , utc_last_status_change_dttm as utc_created_dttm_cp
    from range($CLAIM_POINT_OLD, $MONTH_START)
);

$point = (
    select 
       point_id
       , point_full_address
       , point_comment
    from range($POINT_OLD, $MONTH_START)
);

$claim_status_log = (
    select 
        claim_id
        , some( if (new_claim_status = 'pickup_arrived', utc_created_dttm, null)) as time_arrived_at_storage
        , some( if (new_claim_status = 'performer_found', utc_created_dttm, null)) as time_performer_found
        , some( if (new_claim_status = 'performer_lookup', utc_created_dttm, null)) as time_performer_lookup
    from range($CLAIM_STATUS_LOG_OLD, $MONTH_START)
    group by claim_id
);

$total_hell = (
    select
        * 
    FROM $claim as c
    left join $claim_point as cp on c.claim_id = cp.claim_id
    left join $claim_status_log as cst on c.claim_id = cst.claim_id
    left join $point as p on cp.point_id = p.point_id
    left join $claim_segment_point as csp on cp.claim_point_id = csp.claim_point_id

);

$table_whith_diff = (
    SELECT 
        cargo_ref_id
        , corp_client_id
        , claim_id
        , claim_point_id
        , point_comment
        , point_full_address
        , point_id
        , visit_status
        , point_type
        , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_performer_lookup)), 'Europe/Moscow')) as time_performer_lookup
        , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_performer_found)), 'Europe/Moscow')) as time_performer_found
        , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_arrived_at_storage)), 'Europe/Moscow')) as time_arrived_at_storage
        , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_due_dttm)), 'Europe/Moscow')) as utc_due_dttm
        , DateTime::GetWeekOfYear(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_due_dttm)), 'Europe/Moscow')) as week 
        , DateTime::GetWeekOfYear(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_performer_lookup)), 'Europe/Moscow')) as week_time_performer_lookup
        , DateTime::ToSeconds((AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_arrived_at_storage)), 'Europe/Moscow')) - (AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_due_dttm)), 'Europe/Moscow'))) as diff
        , $date_format(DateTime::FromSeconds(cast(cast((DateTime::MakeDatetime(DateTime::ParseIso8601(time_arrived_at_storage))) - (DateTime::MakeDatetime(DateTime::ParseIso8601(utc_due_dttm))) as int) / (1000000) as Uint32))) as diff_sec
    from $total_hell
    where substring(cast(time_arrived_at_storage as string), 0, 10) = $yesterday_str
);



$performer_info = (
    select
        car_profile_id as car_id
        , claim_id
        , executor_profile_id 
        , full_name
        , park_name
        , park_org_name
        , park_taximeter_id
        , taxi_order_id 
    from range($TAXI_PERFORMER_INFO, $MONTH_START)
    where tariff_class_code in ('cargo', 'cargocorp')
);

INSERT INTO $SAVE_TO 
select 
    th.cargo_ref_id as cargo_ref_id
    , th.corp_client_id as corp_client_id
    , some(
        CASE 
            when th.corp_client_id = '4fd4380db61442849d3ddb91cd9867f5' then 'NDD'
            when th.corp_client_id = '7d41e3375d4f49dfbde17a5c2d17ec4f' then 'Глобус'
            when th.corp_client_id = '10e0550610254cdab46c28cda5efff15' then 'Лавка'
            when th.corp_client_id = '1f86abc44e5e44b8890b533434008d2e' then 'Маркет'
            when th.corp_client_id = 'aa3cf958e6c442e18b4ce6df811f6f14' then 'Яндекс.Услуги'
            when th.corp_client_id = '3c0b9cd4d6474436ade3bb614d60cfed' then 'Элементари'
            when th.corp_client_id = '19392efec6b34084bd846d5dd76f32ad' then 'SimpleWine'
        ELSE null
        end
    ) as corp_name
    -- , th.claim_id as claim_id
    , some(substring(utc_due_dttm,0,10)) as day
    , some(week) as week
    , some(week_time_performer_lookup) as week_time_performer_lookup
    , count(point_id) as cnt_point
    , count_if(point_type = 'destination') as cnt_destination_point
    , count_if(visit_status = 'visited') as visited_point
    , count_if(visit_status = 'skipped') as skipped_point
    , some(time_performer_lookup) as time_performer_lookup
    , some(time_performer_found) as time_performer_found
    , some(time_arrived_at_storage) as time_arrived_at_storage
    , some(utc_due_dttm) as due_dttm
    , some(diff_sec) as diff_sec
    -- , some(diff) as diff
    , some(
        CASE 
            when time_arrived_at_storage > utc_due_dttm then 'late' 
            when time_arrived_at_storage <= utc_due_dttm then 'on time'
        ELSE null
        end
    ) as arrival_status
    , some(
        CASE 
            when diff > 600 then 'arrived after 10 minutes' 
            when diff <= 600 then 'arrived not later than 10 minutes'
        ELSE null
        end
    ) as arrival_status_10_min
    , some(
        CASE 
            when diff > 300 then 'arrived after 5 minutes' 
            when diff <= 300 then 'arrived not later than 5 minutes'
        ELSE null
        end
    ) as arrival_status_5_min
    , some(executor_profile_id) as executor_profile_id
    , some(full_name) as full_name
    , some(park_taximeter_id) as park_taximeter_id
    , some(park_name) as park_name
    , some(park_org_name) as park_org_name
    from $table_whith_diff as th
left join $performer_info as pi on th.claim_id = pi.claim_id
    group by
        th.cargo_ref_id
        , th.corp_client_id
        , th.claim_id
        ;
