use hahn;
PRAGMA yt.Pool = 'taxi-delivery';

$CARGO_ORDERS = '//home/taxi-delivery/analytics/production/cargo/demand/cr_datamart';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';

$SAVE_TO = '//home/taxi-delivery/analytics/production/cargo/demand/oper_dash';

$ACTIVE_WINDOW = 45;

$today = CurrentUtcDate();
$yesterday = $today - Interval('P1D');
$day_before_yesterday = $yesterday - Interval('P1D');
$week_before_yesterday = $yesterday - 7*Interval('P1D');

$min_active_date = $yesterday - $ACTIVE_WINDOW*Interval('P1D');
$min_active_date_week_before = $week_before_yesterday - $ACTIVE_WINDOW*Interval('P1D');

$fct_order_max_date = substring(cast($yesterday as String), 0, 7) || '-01';
$fct_order_min_date = substring(cast($min_active_date as String), 0, 7) || '-01';

$active_executors_before_yesterday = (
    select name_ru
      , corp_order_flg
      , AGGREGATE_LIST_DISTINCT(driver_id) as distinct_drivers
    from $CARGO_ORDERS
    where utc_order_dt between cast($min_active_date as String) and cast($day_before_yesterday as String)
      and human_status='success'
    group by name_ru
      , corp_order_flg
);

$active_executors_yesterday = (
    select co.name_ru as name_ru
      , co.corp_order_flg as corp_order_flg
      , count(driver_id) as new_drivers_yesterday
    from $CARGO_ORDERS as co 
    left join $active_executors_before_yesterday as t1 on co.name_ru=t1.name_ru and co.corp_order_flg=t1.corp_order_flg
    where co.utc_order_dt = cast($yesterday as String)
      and co.driver_id not in t1.distinct_drivers
    group by co.name_ru
      , co.corp_order_flg
);

$active_executors_before_week_before = (
    select name_ru
      , corp_order_flg
      , AGGREGATE_LIST_DISTINCT(driver_id) as distinct_drivers
    from $CARGO_ORDERS
    where utc_order_dt between cast($min_active_date_week_before as String) and cast($week_before_yesterday - Interval('P1D') as String)
      and human_status='success'
    group by name_ru
      , corp_order_flg
);

$active_executors_week_before = (
    select co.name_ru as name_ru
      , co.corp_order_flg as corp_order_flg
      , count(driver_id) as new_drivers_week_before
    from $CARGO_ORDERS as co 
    left join $active_executors_before_week_before as t1 on co.name_ru=t1.name_ru and co.corp_order_flg=t1.corp_order_flg
    where co.utc_order_dt = cast($week_before_yesterday as String)
      and co.driver_id not in t1.distinct_drivers
    group by co.name_ru
      , co.corp_order_flg
);

$reduced = (
SELECT co.name_ru as name_ru
  , co.corp_order_flg as corp_order_flg
  , 1.0 * count_if(co.human_status='success' and co.utc_order_dt=cast($yesterday as String)) / count_if(co.utc_order_dt=cast($yesterday as String)) as cr_yesterday
  , count_if(co.human_status='success' and co.utc_order_dt=cast($yesterday as String)) as trips_yesterday
  , count_if(co.utc_order_dt=cast($yesterday as String)) as orders_yesterday
  , sum_if(fo.order_cost*fo.currency_rate, co.utc_order_dt=cast($yesterday as String)) as gmv_yesterday
  , sum_if(fo.subsidy_value*fo.currency_rate, co.utc_order_dt=cast($yesterday as String)) as sub_yesterday
  , 1.0*sum_if(fo.subsidy_value, co.utc_order_dt=cast($yesterday as String))/sum_if(fo.order_cost, co.utc_order_dt=cast($yesterday as String)) as sub_gmv_yesterday
  , avg_if(fo.order_cost*fo.currency_rate, co.utc_order_dt=cast($yesterday as String)) as avg_order_cost_yesterday
  , count(distinct IF(co.human_status='success' and co.utc_order_dt=cast($yesterday as String), co.driver_id, null)) as drivers_yesterday

  , 1.0 * count_if(co.human_status='success' and co.utc_order_dt=cast($week_before_yesterday as String)) / count_if(co.utc_order_dt=cast($week_before_yesterday as String)) as cr_week_before_yesterday
  , count_if(co.human_status='success' and co.utc_order_dt=cast($week_before_yesterday as String)) as trips_week_before_yesterday
  , count_if(co.utc_order_dt=cast($week_before_yesterday as String)) as orders_week_before_yesterday
  , sum_if(fo.order_cost*fo.currency_rate, co.utc_order_dt=cast($week_before_yesterday as String)) as gmv_week_before_yesterday
  , sum_if(fo.subsidy_value*fo.currency_rate, co.utc_order_dt=cast($week_before_yesterday as String)) as sub_week_before_yesterday
  , 1.0*sum_if(fo.subsidy_value, co.utc_order_dt=cast($week_before_yesterday as String))/sum_if(fo.order_cost, co.utc_order_dt=cast($week_before_yesterday as String)) as sub_gmv_week_before_yesterday
  , avg_if(fo.order_cost*fo.currency_rate, co.utc_order_dt=cast($week_before_yesterday as String)) as avg_order_cost_week_before_yesterday
  , count(distinct IF(co.human_status='success' and co.utc_order_dt=cast($week_before_yesterday as String), co.driver_id, null)) as drivers_week_before_yesterday

  , avg(t1.new_drivers_yesterday) as new_drivers_yesterday
  , avg(t2.new_drivers_week_before) as new_drivers_week_before

  , cast($yesterday as String) as yesterday_utc_dt
  , cast($week_before_yesterday as String) as week_before_utc_dt
from $CARGO_ORDERS as co 
left join range($FCT_ORDER, $fct_order_min_date, $fct_order_max_date) as fo on co.order_id = fo.order_id
left join $active_executors_yesterday as t1 on co.name_ru=t1.name_ru and co.corp_order_flg=t1.corp_order_flg
left join $active_executors_week_before as t2 on co.name_ru=t2.name_ru and co.corp_order_flg=t2.corp_order_flg
group by co.name_ru
  , co.corp_order_flg
);

insert into $SAVE_TO WITH TRUNCATE 
select * 
from $reduced
where trips_yesterday > 0;
