use hahn;
PRAGMA yt.Pool = 'taxi-delivery';

$CARGO_ORDERS = '//home/taxi-delivery/analytics/production/cargo/demand/cr_datamart';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';

$SAVE_TO = '//home/taxi-delivery/analytics/production/cargo/demand/oper_dash_week';

$ACTIVE_WINDOW = 45;

$today = CurrentUtcDate();


$start_of_cur_week = Datetime::MakeDate(DateTime::StartOfWeek($today)); -- Ближайший понедельник
$start_of_prev_week = $start_of_cur_week - Interval('P1W'); -- Понедельник прошлой недели
$start_of_post_prev_week = $start_of_cur_week - 2*Interval('P1W'); -- Понедельник за две недели до

$fct_order_max_date = substring(cast($start_of_cur_week as String), 0, 7) || '-01';
$fct_order_min_date = substring(cast($start_of_post_prev_week as String), 0, 7) || '-01';

$active_executors_last_week = (
    select name_ru
      , corp_order_flg
      , AGGREGATE_LIST_DISTINCT(driver_id) as distinct_drivers
    from $CARGO_ORDERS
    where utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String)
      and human_status='success'
    group by name_ru
      , corp_order_flg
);

$active_executors_last_week_minus_45 = (
    select name_ru
      , corp_order_flg
      , AGGREGATE_LIST_DISTINCT(driver_id) as distinct_drivers
    from $CARGO_ORDERS
    where utc_order_dt between cast($start_of_prev_week - $ACTIVE_WINDOW*Interval('P1D') as String) and cast($start_of_prev_week - Interval('P1D') as String)
      and human_status='success'
    group by name_ru
      , corp_order_flg
);

$new_drivers_last_week = (
    SELECT lw.name_ru as name_ru
      , lw.corp_order_flg as corp_order_flg
      , ListLength(SetDifference(ToSet(lw.distinct_drivers), ToSet(b.distinct_drivers))) as new_drivers_last_week
      , ListLength(lw.distinct_drivers) as drivers_last_week
    from $active_executors_last_week as lw 
    left join $active_executors_last_week_minus_45 as b on lw.name_ru=b.name_ru and lw.corp_order_flg=b.corp_order_flg
);

$active_executors_before_last_week = (
    select name_ru
      , corp_order_flg
      , AGGREGATE_LIST_DISTINCT(driver_id) as distinct_drivers
    from $CARGO_ORDERS
    where utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String)
      and human_status='success'
    group by name_ru
      , corp_order_flg
);

$active_executors_before_last_week_minus_45 = (
    select name_ru
      , corp_order_flg
      , AGGREGATE_LIST_DISTINCT(driver_id) as distinct_drivers
    from $CARGO_ORDERS
    where utc_order_dt between cast($start_of_post_prev_week - $ACTIVE_WINDOW*Interval('P1D') as String) and cast($start_of_post_prev_week - Interval('P1D') as String)
      and human_status='success'
    group by name_ru
      , corp_order_flg
);

$new_drivers_before_last_week = (
    SELECT lw.name_ru as name_ru
      , lw.corp_order_flg as corp_order_flg
      , ListLength(SetDifference(ToSet(lw.distinct_drivers), ToSet(b.distinct_drivers))) as new_drivers_before_last_week
      , ListLength(lw.distinct_drivers) as drivers_before_last_week
    from $active_executors_before_last_week as lw 
    left join $active_executors_before_last_week_minus_45 as b on lw.name_ru=b.name_ru and lw.corp_order_flg=b.corp_order_flg
);

$reduced = (
SELECT co.name_ru as name_ru
  , co.corp_order_flg as corp_order_flg
  , 1.0 * count_if(co.human_status='success' and (co.utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String))) / count_if(co.utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String)) as cr_last_week
  , count_if(co.human_status='success' and (co.utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String))) as trips_last_week
  , count_if(co.utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String)) as orders_last_week
  , sum_if(fo.order_cost*fo.currency_rate, co.utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String)) as gmv_last_week
  , sum_if(fo.subsidy_value*fo.currency_rate, co.utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String)) as sub_last_week
  , 1.0*sum_if(fo.subsidy_value, co.utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String))/sum_if(fo.order_cost, co.utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String)) as sub_gmv_last_week
  , avg_if(fo.order_cost*fo.currency_rate, co.utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String)) as avg_order_cost_last_week
  , count(distinct IF(co.human_status='success' and (co.utc_order_dt between cast($start_of_prev_week as String) and cast($start_of_cur_week - Interval('P1D') as String)), co.driver_id, null)) as drivers_last_week

  , 1.0 * count_if(co.human_status='success' and co.utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String)) / count_if(co.utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String)) as cr_before_last_week
  , count_if(co.human_status='success' and (co.utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String))) as trips_before_last_week
  , count_if(co.utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String)) as orders_before_last_week
  , sum_if(fo.order_cost*fo.currency_rate, co.utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String)) as gmv_before_last_week
  , sum_if(fo.subsidy_value*fo.currency_rate, co.utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String)) as sub_before_last_week
  , 1.0*sum_if(fo.subsidy_value, co.utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String))/sum_if(fo.order_cost, co.utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String)) as sub_gmv_before_last_week
  , avg_if(fo.order_cost*fo.currency_rate, co.utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String)) as avg_order_cost_before_last_week
  , count(distinct IF(co.human_status='success' and co.utc_order_dt between cast($start_of_post_prev_week as String) and cast($start_of_prev_week - Interval('P1D') as String), co.driver_id, null)) as drivers_before_last_week

  , avg(t1.new_drivers_last_week) as new_drivers_last_week
  , avg(t1.drivers_last_week) as drivers_last_week_alt
 
  , avg(t2.new_drivers_before_last_week) as new_drivers_before_last_week
  , avg(t2.drivers_before_last_week) as drivers_before_last_week_alt

  , cast($start_of_prev_week as String) as yesterday_utc_dt
  , cast($start_of_post_prev_week as String) as week_before_utc_dt
from $CARGO_ORDERS as co 
left join range($FCT_ORDER, $fct_order_min_date, $fct_order_max_date) as fo on co.order_id = fo.order_id
left join $new_drivers_last_week as t1 on co.name_ru=t1.name_ru and co.corp_order_flg=t1.corp_order_flg
left join $new_drivers_before_last_week as t2 on co.name_ru=t2.name_ru and co.corp_order_flg=t2.corp_order_flg
group by co.name_ru
  , co.corp_order_flg
);

insert into $SAVE_TO WITH TRUNCATE 
select * 
from $reduced
where trips_last_week > 0;
