use hahn;

$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';

$SAVE_TO = '//home/taxi-delivery/analytics/production/cargo/operations/parks_info';

$START_DAY = '2021-06-01';

$start_month = substring($START_DAY, 0, 7) || '-01';

INSERT INTO $SAVE_TO WITH TRUNCATE 
SELECT fo.utc_order_created_dt as utc_order_created_dt
  , geo.name_ru as agglomeration_name_ru
  , fo.taximeter_park_id as park_taximeter_id
  , some(fo.park_client_id) as park_client_id
  , some(fo.park_client_name) as park_client_name
  , some(geo.tz_country_name_ru) as country_name_ru
  , count(fo.order_id) as orders_cnt
  , count_if(fo.success_order_flg) as trips_cnt
from range($FCT_ORDER, $start_month) as fo
left join $GEO as geo on geo.tariff_zone=fo.tariff_geo_zone_code
where not fo.fake_order_flg
--  and not fo.user_fraud_flg
  and not fo.mqc_order_flg
  and fo.tariff_class_code in ('cargo', 'cargocorp')
  and geo.node_type = 'agglomeration'
  and geo.root_node_id = 'br_root'
  and fo.executor_profile_sk is not null
group by fo.utc_order_created_dt
  , geo.name_ru
  , fo.taximeter_park_id;
  
