import os
from business_models.databases.greenplum import GreenplumManager
from business_models.databases.hahn import HahnDataLoader

if __name__ == '__main__':
    user = os.environ['USER']
    gp_token = os.environ['GP_TOKEN']
    yt_token = os.environ['YT_TOKEN']
    hahn = HahnDataLoader(token=yt_token)
    gp = GreenplumManager(user=user, token=gp_token)
    gp.replicate(
        yt_path = '//home/taxi-analytics/erik-nazarov/cargo_orders/orders',
        table_name = 'snb_taxi.erik_nazarov_cargo_orders'
    )
    gp(
    '''
    GRANT ALL ON snb_taxi.erik_nazarov_cargo_orders to "erik-nazarov";
    '''
    )
    
