/*
    Зачем скрипт?
    Выгружать звонки, в рамках которых потенциально был сговор юзер-исполнитель в "Грузовом" в Яндекс Доставке

    Автор:
    @ikhomyanin

    Тикет:
    LOGDATA-1022
*/

use hahn;

$FORWARDINGS = '//home/taxi/production/private/postgres/vgw_api/forwardings';
$TALKS = '//home/taxi/production/private/postgres/vgw_api/talks';
$ORDERS = '//home/taxi-delivery/analytics/production/cargo/demand/cr_datamart';

$today = CurrentUtcDate();
$yesterday = cast($today - Interval('P1D') as String);
$four_weeks_ago = cast($today - 28*Interval('P1D') as String);

$SAVE_TO = '//home/taxi-delivery/analytics/production/cargo/possibly_fraud_calls/' || $yesterday;

$format_dttm = DateTime::Format('%Y-%m-%d %H:%M:%S');

$URL = 'https://tariff-editor.taxi.yandex-team.ru/orders/';

$interesting_orders = (
    select order_id
        , $URL || order_id || '/calls' as call_link
        , name_ru as city
        , user_phone_pd_id
        , driver_id
        , car_type
    from $ORDERS
    where 1=1
        and dash_status = 'cancelled_by_user_after_assign'
        and utc_order_dt = $yesterday
        and tz_country_name_ru = 'Россия'
);

$drivers_info = (
    select driver_id
        , count(order_id) as orders_cnt
        , count_if(dash_status in (
                'cancelled_by_user_after_assign',
                'cancelled_by_operator',
                'cancelled_by_driver'
            )
        ) as cancellations_cnt
        , 1.0 * count_if(dash_status in (
                'cancelled_by_user_after_assign',
                'cancelled_by_operator',
                'cancelled_by_driver'
            )
        ) / count(order_id) as share_cancelled
    from $ORDERS
    where 1=1
        and driver_id in (
            select driver_id
            from $interesting_orders
        )
        and utc_order_dt between $four_weeks_ago and $yesterday
    group by driver_id
);

$talks_df = (
    select $format_dttm(DateTime::FromSeconds(cast(t.created_at as Uint32))) as utc_call_created_dttm
        , `length` as call_length_sec
        , t.forwarding_id as forwarding_id
    from $TALKS as t
    where 1=1
        and substring($format_dttm(DateTime::FromSeconds(cast(t.created_at as Uint32))), 0, 10) >= $yesterday
        and `length` > 10
);

$forwardings_df = (
    select $format_dttm(DateTime::FromSeconds(cast(f.created_at as Uint32))) as utc_forwarding_created_dttm
        , f.external_ref_id as order_id
        , f.id as forwarding_id
        , f.caller as caller
        , f.callee as callee
    from $FORWARDINGS as f 
    where 1=1
        and substring($format_dttm(DateTime::FromSeconds(cast(f.created_at as Uint32))), 0, 10) >= $yesterday
        and caller in ('passenger', 'driver')
        and callee in ('passenger', 'driver')
);

$final = (
    select *
    from $talks_df as t
    left join $forwardings_df as f on t.forwarding_id = f.forwarding_id
    inner join $interesting_orders as o on f.order_id = o.order_id
    left join $drivers_info as d on d.driver_id=o.driver_id
    order by d.share_cancelled desc
);

insert into $SAVE_TO with truncate
select *
from $final;
