from datetime import datetime, timedelta
import pandas as pd

import yt.wrapper as yt
from business_models.startrek import StartrekWrapper

TICKET_ID = 'LOGDATA-1067'

def current_utc_timestamp():
     return datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')

def main():
    print(f'{current_utc_timestamp()} - START')
    yesterday = (datetime.utcnow() - timedelta(days=1)).strftime('%Y-%m-%d')
    
    print(f'{current_utc_timestamp()} - Importing data')
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    DATA_PATH = f'//home/taxi-delivery/analytics/production/cargo/possibly_fraud_calls/{yesterday}'
    df = pd.DataFrame(list(yt.read_table(DATA_PATH)))
    
    print(f'{current_utc_timestamp()} - Creating excel')
    FILENAME = f'calls_{yesterday}.xlsx'
     
    df['sorting_rule'] = df['cancellations_cnt'] * df['share_cancelled']
    df.sort_values(by=['sorting_rule'], ascending=False, inplace=True)
     
    df.to_excel(FILENAME, index=False)
    
    print(f'Sending to {TICKET_ID}...')
    st = StartrekWrapper()
    st.comment(TICKET_ID, 
               text=f'Данные для обзвона за {yesterday}', 
               attachments=FILENAME,
               summonees=['yana-m97'])


if __name__ == '__main__':
    main()
    
