use hahn; 
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$CR_DATAMART = '//home/taxi-delivery/analytics/production/cargo/demand/cr_datamart';
$SUPPLY = '//home/taxi-delivery/analytics/production/cargo/supply/cargo_supply_datamart';
$FCT_ORDER_METRIC = '//home/taxi-dwh/cdm/marketplace/fct_order_metric';
$ACTUAL_TAGS = '//home/taxi/production/replica/postgres/tags/actual_tags';

-- выбираем индификатор, на который вешали тег
$ENTITY_TYPE = "dbid_uuid";
-- прописываем сам тег, который заводили
$TAG = "cargo_core_supply"; 

$today = CurrentUtcDate();
$yesterday = cast($today - Interval('P2D') as string);
$week_ago = cast($today - Interval('P8D') as string);
$month = substring($week_ago, 0, 7) || '-01';
$day_of_recording = cast($today as string);

$SAVE_TO = '//home/taxi-delivery/analytics/production/cargo/supply/cargo_core_supply/' || $day_of_recording;

$tag_entity = (
    select 
        entity
    from $ACTUAL_TAGS 
    where tag = $TAG
    and entity_type = $ENTITY_TYPE
);


$cargo_supply = ( 
    select 
        utc_dt 
        , driver_uuid
        , executor_profile_sk
        , some(park_dbid || "_" || driver_uuid) as dbid_uuid
        , some(park_clid) as park_clid
        , driver_id
        ,  1.*( SUM(free_time_sec) + 
                SUM(driving_time_sec_cargo) + SUM(waiting_time_sec_cargo) + SUM(transporting_time_sec_cargo) +
                SUM(driving_time_sec_cargocorp) + SUM(waiting_time_sec_cargoorp) + SUM(transporting_time_sec_cargoorp)
                )/3600 AS sh_hours
        , (SUM(driving_distance_km_cargo) + SUM(driving_distance_km_cargocorp) +
                SUM(transporting_distance_km_cargo) + SUM(transporting_distance_km_cargoorp)) as fact_km 
        , 1.*(SUM(cancelled_by_driver_cargo + cancelled_by_driver_cargocorp)) /( SUM(orders_seen_cargo + orders_seen_cargocorp)) as reject_rate
        , some(agglomeration_name) as agglomeration_name
        , some(size_group) as size_group
    from $SUPPLY 
    where utc_dt between $week_ago and $yesterday
        and park_dbid || "_" || driver_uuid in (
                            select entity
                            from $tag_entity
                    )
    group by utc_dt
        , driver_uuid
        , executor_profile_sk
        ,  park_clid || "_" || driver_uuid as driver_id
);


$fct = (
    select
    fct.executor_profile_sk as executor_profile_sk
    , some(substring(fct.utc_order_due_dttm,0,10)) as utc_order_due_dt
    , cr.driver_id as driver_id
    , cr.utc_order_dt as utc_order_dt
    , some(utc_order_created_dt) as utc_order_created_dt
    , fct.lcl_order_created_dt as lcl_dt
    , some(lcl_order_due_dttm) as lcl_order_due_dttm -- когда заказ должны откатать
    , SUM(transporting_distance_plan_km) as plan_km
    , SUM(driver_cost) as driver_cost -- начисленная сумма 
    , SUM(driver_net_income_incl_paid_cancel_amt + park_commission_w_vat_value) as taximeter -- сумма в таксометре
    , sum(destination_points) as cnt_destination_points
        , sum(cnt_visited_points) as cnt_visited_points
        , COUNT_IF(dash_status = 'cancelled_by_driver') as cnt_cancelled_by_driver 
        , count(cr.order_id) as cnt_order_id
        , 1.*(COUNT_IF(dash_status = 'cancelled_by_driver')) / (count(cr.order_id)) as cancel_rate 
    from range($FCT_ORDER_METRIC, $month) as fct
    left join $CR_DATAMART as cr on fct.order_id = cr.order_id
    where substring(lcl_order_due_dttm,0,10) between $week_ago and $yesterday
    and executor_profile_sk in (
        select executor_profile_sk
        from $cargo_supply
    )
    group by fct.executor_profile_sk
    -- , utc_order_created_dt
    , fct.lcl_order_created_dt
    , cr.driver_id
    , cr.utc_order_dt 
);
$test = (
    select
        fct.*
        , sh_hours
        , reject_rate
        , agglomeration_name
        , size_group
        , utc_dt
        , fact_km
        , dbid_uuid
    from $fct as fct
    left join $cargo_supply as cs on fct.driver_id=cs.driver_id and fct.utc_order_due_dt = cs.utc_dt

);

INSERT INTO $SAVE_TO WITH TRUNCATE 

SELECT DISTINCT 
    utc_order_dt as utc_order_creation_date
    , utc_dt as utc_order_execution_date
    , dbid_uuid
    , sh_hours
    , fact_km
    , plan_km 
    , driver_cost
    , taximeter
    , reject_rate
    , cancel_rate
    , cnt_visited_points
    , cnt_destination_points
    , CASE 
        when size_group = 'LARGE' then 'LARGE'
        when size_group = 'LARGE / MEDIUM' then 'LARGE'
        when size_group = 'MEDIUM' then 'MEDIUM'
        when size_group = 'MEDIUM / VAN' then 'MEDIUM'
        when size_group = 'VAN' then 'VAN'
     ELSE 'NONE'
    END as car_size
    --, size_group
    , agglomeration_name
from $test
order by utc_order_execution_date;
