# -*- coding: utf-8 -*-

import logging
import pandas as pd
import yt.wrapper as yt
from datetime import datetime
from projects.common.helpers import build_gdocs 

gdocs = build_gdocs()

SCHEMA = [  
 dict(name='park_car_id', type="string"), 
 dict(name='tag', type="string")
]
TABLE_NAME = "//home/taxi-delivery/analytics/production/cargo/supply/park_car_id_tags"
COLUMNS = [
   "park_car_id",
    "tag"
]

def write_replica_gdocs():
    log = gdocs.read(
        table_name="Sheet2",
        sheet_id="1fmiQSqYcknxhzW-Uw2FMobC-HCRMmkQ17wvc3WD6dos",
        header=1
    ).iloc[:, 0:len(COLUMNS)]
    log.columns = COLUMNS


    data = log.to_dict(orient="records")
    #return log
    yt.write_table(yt.TablePath(TABLE_NAME, schema=SCHEMA), data)
    
def main():
    write_replica_gdocs()


if __name__ == "__main__":
    yt.config.set_proxy("hahn")
    main()

