-- ВИТРИНА ПО САППЛАЮ КАРГО

use hahn;
PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$SUPP = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$EXEC = '//home/taxi-dwh/cdm/supply/dim_executor_profile_hist';
$CARS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_cars';
$CANDIDATES = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$SAVE_TO = '//home/taxi-delivery/analytics/production/cargo/supply/cargo_supply_datamart';

$START_MONTH = '2021-03';
$START_DATE = '2021-03-01';

-- 1. ВРЕМЯ, КОТОРОЕ ИСПОЛНИТЕЛЬ ПРОВОДИТ В РАЗНЫХ СТАТУСАХ
$supply_time = (
    select utc_dt
        , executor_profile_sk
        , some(s.executor_profile_id) as driver_uuid
        , some(s.park_taximeter_id) as park_dbid
        , some(s.park_client_id) as park_clid
        , TryMember(mode(s.agglomeration_geo_node_id)[0], 'Value', null) as agglomeration_geo_node_id
        , TryMember(mode(s.tariff_geo_zone_code)[0], 'Value', null) as tariff_geo_zone_code
        , coalesce(SUM_IF(duration_sec, executor_status_code='free'),0) as free_time_sec
        , coalesce(SUM_IF(duration_sec, executor_status_code='driving' and (tariff_class_code = 'cargo')),0) as driving_time_sec_cargo
        , coalesce(SUM_IF(duration_sec, executor_status_code='waiting' and (tariff_class_code = 'cargo')),0) as waiting_time_sec_cargo
        , coalesce(SUM_IF(duration_sec, executor_status_code='transporting' and (tariff_class_code = 'cargo')),0) as transporting_time_sec_cargo
        , coalesce(SUM_IF(duration_sec, executor_status_code='driving' and (tariff_class_code = 'cargocorp')),0) as driving_time_sec_cargocorp
        , coalesce(SUM_IF(duration_sec, executor_status_code='waiting' and (tariff_class_code = 'cargocorp')),0) as waiting_time_sec_cargoorp
        , coalesce(SUM_IF(duration_sec, executor_status_code='transporting' and (tariff_class_code = 'cargocorp')),0) as transporting_time_sec_cargoorp
        , coalesce(SUM_IF(duration_sec, executor_status_code='driving' and (tariff_class_code != 'cargo' and tariff_class_code != 'cargocorp')),0) as driving_time_sec_not_cargo
        , coalesce(SUM_IF(duration_sec, executor_status_code='waiting' and (tariff_class_code != 'cargo' and tariff_class_code != 'cargocorp')),0) as waiting_time_sec_not_cargo
        , coalesce(SUM_IF(duration_sec, executor_status_code='transporting' and (tariff_class_code != 'cargo' and tariff_class_code != 'cargocorp')),0) as transporting_time_sec_not_cargo
        
        , coalesce(SUM_IF(distance_km, executor_status_code='free'),0) as free_distance_km
        , coalesce(SUM_IF(distance_km, executor_status_code='driving' and (tariff_class_code = 'cargo')),0) as driving_distance_km_cargo
        , coalesce(SUM_IF(distance_km, executor_status_code='waiting' and (tariff_class_code = 'cargo')),0) as waiting_distance_km_cargo
        , coalesce(SUM_IF(distance_km, executor_status_code='transporting' and (tariff_class_code = 'cargo')),0) as transporting_distance_km_cargo
        , coalesce(SUM_IF(distance_km, executor_status_code='driving' and (tariff_class_code = 'cargocorp')),0) as driving_distance_km_cargocorp
        , coalesce(SUM_IF(distance_km, executor_status_code='waiting' and (tariff_class_code = 'cargocorp')),0) as waiting_distance_km_cargoorp
        , coalesce(SUM_IF(distance_km, executor_status_code='transporting' and (tariff_class_code = 'cargocorp')),0) as transporting_distance_km_cargoorp
        , coalesce(SUM_IF(distance_km, executor_status_code='driving' and (tariff_class_code != 'cargo' and tariff_class_code != 'cargocorp')),0) as driving_distance_km_not_cargo
        , coalesce(SUM_IF(distance_km, executor_status_code='waiting' and (tariff_class_code != 'cargo' and tariff_class_code != 'cargocorp')),0) as waiting_distance_km_not_cargo
        , coalesce(SUM_IF(distance_km, executor_status_code='transporting' and (tariff_class_code != 'cargo' and tariff_class_code != 'cargocorp')),0) as transporting_distance_km_not_cargo
    
        , CASE
            when SUM(duration_sec*(
              CASE
                 WHEN SetIncludes(ToSet(AsList('cargo', 'cargocorp')), ToSet(Yson::ConvertToStringList(s.enabled_tariff_class_code_list)))
                 THEN 1
                 ELSE 0
              END
            )) >= 0.5*SUM(duration_sec)
            then 1
            else 0
          end as cargo_only_flg 
    from RANGE($SUPP, $START_MONTH) as s
    left join RANGE($FCT_ORDER, $START_MONTH) as o on s.order_id = o.order_id
    where (('cargo' in Yson::ConvertToStringList(s.enabled_tariff_class_code_list)) or ('cargocorp' in Yson::ConvertToStringList(s.enabled_tariff_class_code_list)))
        and executor_status_code in ('free', 'driving', 'waiting', 'transporting')
    group by substring(s.utc_valid_from_dttm, 0, 10) as utc_dt
        , s.executor_profile_sk as executor_profile_sk
);

-- 2. РАЗМЕРЫ МАШИН
$cargo_exec_sizes = (
    select utc_dt
        ,  s.executor_profile_sk as executor_profile_sk
        ,  SOME(CASE
              WHEN utc_dt < '2021-05-30' THEN (
                CASE 
                  WHEN (
                    (
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 180 AND 250) and 
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 380 and 601) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 180 and 250)   
                    )

                    AND NOT 
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 230) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 520) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 230)    
                    )
                  ) THEN 'LARGE'
                  WHEN (
                    (
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 230) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 520) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 230)   
                    )

                    AND NOT
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 180 AND 250) and 
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 380 and 601) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 180 and 250)  
                    )

                    AND NOT
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 90 AND 201) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 170 and 290) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 96 and 201)
                    )
                  ) THEN 'MEDIUM'
                  WHEN (
                    (
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 90 AND 201) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 170 and 290) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 96 and 201)   
                    )

                    AND NOT
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 230) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 520) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 230)  
                    )
                  ) THEN 'VAN'
                  WHEN (
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 180 AND 250) and 
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 380 and 601) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 180 and 250)   
                    )

                    AND
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 230) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 520) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 230)  
                    )
                  ) THEN 'LARGE / MEDIUM'
                  WHEN (
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 230) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 520) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 230)  
                    )

                    AND 
                    (
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 90 AND 201) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 170 and 290) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 96 and 201)   
                    )
                  ) THEN 'MEDIUM / VAN'
                  ELSE 'NONE'
                END
              )
              WHEN utc_dt >= '2021-05-30' THEN (
                CASE 
                  WHEN (
                    (
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 180 AND 250) and 
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 380 and 601) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 180 and 250)   
                    )

                    AND NOT 
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 250) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 601) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 250)    
                    )
                  ) THEN 'LARGE'
                  WHEN (
                    (
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 250) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 601) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 250)   
                    )

                    AND NOT
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 180 AND 250) and 
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 380 and 601) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 180 and 250)  
                    )

                    AND NOT
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 90 AND 201) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 170 and 290) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 96 and 201)
                    )
                  ) THEN 'MEDIUM'
                  WHEN (
                    (
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 90 AND 201) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 170 and 290) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 96 and 201)   
                    )

                    AND NOT
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 250) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 601) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 250)
                    )
                  ) THEN 'VAN'
                  WHEN (
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 180 AND 250) and 
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 380 and 601) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 180 and 250)   
                    )

                    AND
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 250) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 601) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 250)  
                    )
                  ) THEN 'LARGE / MEDIUM'
                  WHEN (
                    (
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 150 AND 250) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 260 and 601) and
                      (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 130 and 250)
                    )

                    AND 
                    (
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.height) between 90 AND 201) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.length) between 170 and 290) and
                       (Yson::ConvertToInt64(c.cargo_hold_dimensions.width) between 96 and 201)   
                    )
                  ) THEN 'MEDIUM / VAN'
                  ELSE 'NONE'
                END
              )
              ELSE 'ERROR'
        END) AS size_group
        , SOME(CASE c.cargo_loaders_amount
            WHEN 0 THEN '0'
            WHEN 1 THEN '1'
            WHEN 2 THEN '2'
            ELSE 'NONE'
        END) as loaders_amount
        , some(c.brand) as car_brand
        , some(c.model) as car_model
        , some(c.year) as car_year
        , some(c.car_id) as car_id
        , some(c.number_normalized) as number_normalized
        , some(c.number) as number
    from range($SUPP, $START_MONTH) as s
    left join RANGE($EXEC, $START_MONTH) as e on s.executor_profile_sk=e.executor_profile_sk
    left join $CARS as c on c.car_id=e.car_profile_id and c.park_id=e.park_taximeter_id
    where (('cargo' in Yson::ConvertToStringList(s.enabled_tariff_class_code_list)) or ('cargocorp' in Yson::ConvertToStringList(s.enabled_tariff_class_code_list)))
    and s.utc_valid_from_dttm >= e.utc_valid_from_dttm
    and s.utc_valid_to_dttm < e.utc_valid_to_dttm
    and s.executor_profile_sk is not null
    group by substring(s.utc_valid_from_dttm, 0, 10) as utc_dt
      , s.executor_profile_sk as executor_profile_sk
      
);

-- 3. ДЕНЬГИ ИСПОЛНИТЕЛЕЙ
$exec_with_orders = (
    select DISTINCT executor_profile_sk
    , order_id
    from RANGE($SUPP, $START_MONTH) as s
    where (('cargo' in Yson::ConvertToStringList(s.enabled_tariff_class_code_list)) or ('cargocorp' in Yson::ConvertToStringList(s.enabled_tariff_class_code_list)))
);

$supply_money = (
    select utc_dt
    , s.executor_profile_sk as executor_profile_sk
    , coalesce(sum(CASE
                    WHEN (o.success_order_flg OR o.paid_cancel_order_flg) AND o.tariff_class_code = 'cargo' THEN
                        (o.driver_cost + o.subsidy_value + o.holded_subsidy_value +
                        o.subsidy_commission_discount_value - o.order_commission_w_discount_wo_vat_value -
                        o.order_commission_vat_value - o.shift_commission_w_vat_value - o.call_center_commission_w_vat_value -
                        o.childchair_rent_w_vat_value - o.voucher_commission_wo_vat_value - o.holded_subsidy_commission_value -
                        o.subsidy_commission_value - o.driver_fix_comission_wo_vat_amt -
                        o.driver_fix_comission_for_fraud_wo_vat_amt - o.acquiring_commission_value - o.rebate_w_vat_value -
                        o.agency_commission_w_vat_value) * o.currency_rate
                    ELSE 0
            END),0) as driver_income_rub_cargo
        , coalesce(sum(CASE
                    WHEN (o.success_order_flg OR o.paid_cancel_order_flg) AND o.tariff_class_code = 'cargocorp' THEN
                        (o.driver_cost + o.subsidy_value + o.holded_subsidy_value +
                        o.subsidy_commission_discount_value - o.order_commission_w_discount_wo_vat_value -
                        o.order_commission_vat_value - o.shift_commission_w_vat_value - o.call_center_commission_w_vat_value -
                        o.childchair_rent_w_vat_value - o.voucher_commission_wo_vat_value - o.holded_subsidy_commission_value -
                        o.subsidy_commission_value - o.driver_fix_comission_wo_vat_amt -
                        o.driver_fix_comission_for_fraud_wo_vat_amt - o.acquiring_commission_value - o.rebate_w_vat_value -
                        o.agency_commission_w_vat_value) * o.currency_rate
                    ELSE 0
            END),0) as driver_income_rub_cargocorp
        , coalesce(sum(CASE
                WHEN (o.success_order_flg OR o.paid_cancel_order_flg) AND o.tariff_class_code != 'cargo' AND o.tariff_class_code != 'cargocorp' THEN
                    (o.driver_cost + o.subsidy_value + o.holded_subsidy_value +
                    o.subsidy_commission_discount_value - o.order_commission_w_discount_wo_vat_value -
                    o.order_commission_vat_value - o.shift_commission_w_vat_value - o.call_center_commission_w_vat_value -
                    o.childchair_rent_w_vat_value - o.voucher_commission_wo_vat_value - o.holded_subsidy_commission_value -
                    o.subsidy_commission_value - o.driver_fix_comission_wo_vat_amt -
                    o.driver_fix_comission_for_fraud_wo_vat_amt - o.acquiring_commission_value - o.rebate_w_vat_value -
                    o.agency_commission_w_vat_value) * o.currency_rate
                ELSE 0
        END),0) as driver_income_rub_not_cargo
        , coalesce(count_if(o.success_order_flg and o.tariff_class_code = 'cargo'),0) as trips_cargo
        , coalesce(count_if(o.success_order_flg and o.tariff_class_code = 'cargocorp'),0) as trips_cargocorp
        , coalesce(count_if(o.success_order_flg and o.tariff_class_code != 'cargo' and o.tariff_class_code != 'cargocorp'),0) as trips_not_cargo
        , coalesce(count_if(o.user_status = 'finished' and o.driver_status = 'failed' and o.tariff_class_code = 'cargo'),0) as cancelled_by_driver_cargo
        , coalesce(count_if(o.user_status = 'finished' and o.driver_status = 'failed' and o.tariff_class_code = 'cargocorp'),0) as cancelled_by_driver_cargocorp
        , coalesce(count_if(o.user_status = 'finished' and o.driver_status = 'cancelled' and o.tariff_class_code = 'cargo'),0) as cancelled_by_operator_cargo
        , coalesce(count_if(o.user_status = 'finished' and o.driver_status = 'cancelled' and o.tariff_class_code = 'cargocorp'),0) as cancelled_by_operator_cargocorp
    from $exec_with_orders as s
    left join RANGE($FCT_ORDER, $START_MONTH) as o on s.order_id = o.order_id
    where utc_order_created_dt is not null
    group by substring(utc_order_created_dt, 0, 10) as utc_dt
      , s.executor_profile_sk
);

-- 4. ACCEPTANCE RATE ИСПОЛНИТЕЛЕЙ
$cargo_exec = (
    select distinct executor_profile_sk
    from RANGE($SUPP, $START_MONTH) as s
    where (('cargo' in Yson::ConvertToStringList(s.enabled_tariff_class_code_list)) or ('cargocorp' in Yson::ConvertToStringList(s.enabled_tariff_class_code_list)))
);

$supply_ar = (
    select utc_dt
        , e.executor_profile_sk as executor_profile_sk
        , COALESCE(count_if(c.utc_seen_dttm is not null and o.tariff_class_code = 'cargo'),0) as orders_seen_cargo
        , COALESCE(count_if(c.utc_assigned_dttm is not null and o.tariff_class_code = 'cargo'),0) as orders_assigned_cargo
        , COALESCE(count_if(c.utc_seen_dttm is not null and o.tariff_class_code = 'cargocorp'),0) as orders_seen_cargocorp
        , COALESCE(count_if(c.utc_assigned_dttm is not null and o.tariff_class_code = 'cargocorp'),0) as orders_assigned_cargocorp
        , COALESCE(count_if(c.utc_seen_dttm is not null and o.tariff_class_code != 'cargo' and o.tariff_class_code != 'cargocorp'),0) as orders_seen_not_cargo
        , COALESCE(count_if(c.utc_assigned_dttm is not null and o.tariff_class_code != 'cargo' and o.tariff_class_code != 'cargocorp'),0) as orders_assigned_not_cargo
    from $cargo_exec as e
    left join RANGE($CANDIDATES, $START_DATE) as c on e.executor_profile_sk=c.executor_profile_sk
    left join RANGE($FCT_ORDER, $START_MONTH) as o on o.order_id=c.order_id
    where e.executor_profile_sk is not null
      and c.utc_seen_dttm is not null
    group by e.executor_profile_sk
      , substring(c.utc_seen_dttm, 0, 10) as utc_dt
);

-- 5. GEO
$geo_data = (
    select distinct agglomeration_node_id
      , name_ru
    from $GEO
    where root_node_id = 'br_root'
      and node_type = 'agglomeration'
);

-- 6. ВСЕ СДЖОЙНИТЬ И ПОЛОЖИТЬ НА ЫТЬ
$data = (
    select *
    from $supply_time as t
    left join $cargo_exec_sizes as s on t.executor_profile_sk=s.executor_profile_sk and t.utc_dt=s.utc_dt
    left join $supply_money as m on m.executor_profile_sk=t.executor_profile_sk and m.utc_dt=t.utc_dt
    left join $supply_ar as ar on ar.executor_profile_sk=t.executor_profile_sk and ar.utc_dt=t.utc_dt
);

 insert into $SAVE_TO with truncate
SELECT t.*
  , g.name_ru as agglomeration_name
  , CASE 
      WHEN driving_time_sec_not_cargo > 0
      THEN 0
      ELSE 1
    END as erik_cargo_only_flg
from $ data as t
  left join $geo_data as g
on t.agglomeration_geo_node_id=g.agglomeration_node_id;
