import os

import gptransfer_client


class GPTransferClient(gptransfer_client.GPTransferClient):
    """
    User instruction:
    https://wiki.yandex-team.ru/taxi/dwh/tools/Greenplum/gptransfer-service/manual
    """

    def __init__(
            self,
            token: str = None,
            gp_user: str = None,
            gp_password: str = None,
            host: str = None,
            verify_https: bool = True,
    ):
        """
        Instantiate GPTransferClient.
        :param token: GPTransfer Oauth token
        :param gp_user: GP User
        :param gp_password: GP Password
        :param host: gptransfer host
        :param verify_https: verify HTTPS or not in request
        Usage::
            client = GPTransferClient(
                token='my GPTransfer token',
                gp_user='gp_user',
                gp_password='gp_password',
                host='https://gptransfer.taxi.tst.yandex.net',
                verify_https=False
            )
        """

        if token is None:
            token = os.environ.get('GP_TRANSFER_TOKEN')
        if gp_user is None:
            gp_user = os.environ.get('GP_USER')
        if gp_password is None:
            gp_password = os.environ.get('GP_PASSWORD')
        if host is None:
            host = os.environ.get('GP_TRANSFER_HOST')
        super().__init__(
            token=token,
            gp_user=gp_user,
            gp_password=gp_password,
            host=host,
            verify_https=verify_https,
        )
