import ticket_parser2_py3.api.v1.exceptions as tp2_exceptions
import ticket_parser2_py3.api.v1 as tp2


class TvmRequestError(Exception):
    """Error during performing request to tvm."""


class TVMClient:
    def __init__(self, tvm_secret: str, src_id: int, dsts: dict):
        self._tvm_client = tp2.TvmClient(
            tp2.TvmApiClientSettings(
                self_client_id=src_id,
                enable_service_ticket_checking=True,
                enable_user_ticket_checking=tp2.BlackboxEnv.Test,
                self_secret=tvm_secret,
                dsts=dsts,
            ),
        )

    def get_ticket(self, dst_service_name):
        try:
            return self._tvm_client.get_service_ticket_for(dst_service_name)
        except tp2_exceptions.TvmException as ex:
            raise TvmRequestError(
                f'cannot perform request to {dst_service_name}: {ex}',
            )
