import io
from PIL import Image

def images_merged_vertically_b(images):
    """Вертикально склеивает картинки в заданном порядке и возвращает в бинарном виде"""

    total_height = 0
    max_width = 0

    for img in images:
        total_height += img.size[1]
        max_width = max(max_width, img.size[0])

    new_img = Image.new('RGB', (max_width, total_height))

    current_height = 0
    for img in images:
        new_img.paste(img, (0, current_height))
        current_height += img.size[1]

    buf = io.BytesIO()
    new_img.save(buf, format='png')
    return buf.getvalue()
