import datetime
from typing import AnyStr, List, Union


def get_range(
        date_from: Union[datetime.datetime, AnyStr],
        date_to: Union[datetime.datetime, AnyStr],
        date_format: AnyStr = '%Y-%m-%d',
        normalize: bool = False,
        freq: str = 'D',
) -> List[AnyStr]:
    """
    wrapper of pandas.date_range, but formats all objects with date_format
    """
    import pandas

    return sorted(
        set(
            date.strftime(date_format)
            for date in pandas.date_range(
                date_from, date_to, normalize=normalize, freq=freq,
            )
        ),
    )


def range_selector(
        date_from: Union[datetime.datetime, AnyStr],
        date_to: Union[datetime.datetime, AnyStr],
        date_format: AnyStr = '%Y-%m-%d',
        normalize: bool = False,
        freq: str = 'D',
) -> AnyStr:
    """
    return: dates selector in nile format
    """
    dates = get_range(
        date_from,
        date_to,
        date_format=date_format,
        normalize=normalize,
        freq=freq,
    )
    return f'{{{",".join(dates)}}}'
