from nile.api.v1 import clusters
from qb2.api.v1 import typing


TYPES = {
    'string': typing.String,
    'utf8': typing.Unicode,
    'double': typing.Float,
    'boolean': typing.Bool,
    'int8': typing.Int8,
    'int16': typing.Int16,
    'int32': typing.Int32,
    'int64': typing.Int64,
    'uint8': typing.UInt8,
    'uint16': typing.UInt16,
    'uint32': typing.UInt32,
    'uint64': typing.UInt64,
    'any': typing.Yson,
}


def get_schema(cluster: clusters.yt.Cluster, path: str):
    return cluster.driver.get_attribute(path, 'schema')


def get_schema_dict(cluster: clusters.yt.Cluster, path: str):
    return {
        item['name']: (
            TYPES[item['type']]
            if item['required']
            else typing.Optional[TYPES[item['type']]]
        )
        for item in get_schema(cluster, path)
    }
