import requests
import logging

logger = logging.getLogger('telegram')

ERROR_CAPTION_TOO_LONG = 'Bad Request: MEDIA_CAPTION_TOO_LONG'


class TelegramClient:
    def __init__(self, token, proxies=None):
        self._token = token
        self._session = requests.Session()

        if proxies:
            self._session.proxies.update(proxies)

    def send_message(self, msg, chat_id, reply_to_message_id=None):
        multipart_form_data = {
            'action': (None, 'send'),
            'chat_id': (None, chat_id),
            'text': (None, msg),
            'parse_mode': (None, 'html'),
        }

        if reply_to_message_id:
            multipart_form_data['reply_to_message_id'] = (None, reply_to_message_id)

        response = self._session.get(f'https://api.telegram.org/bot{self._token}/sendMessage',
                                     files=multipart_form_data, verify=False)

        if not response.json()['ok']:
            raise RuntimeError(response.json())

    def send_photo(self, photo, msg, chat_id):
        multipart_form_data = {
            'photo': ('grafana.png', photo),
            'action': (None, 'send'),
            'chat_id': (None, chat_id),
            'parse_mode': (None, 'html'),
        }

        if msg:
            multipart_form_data['caption'] = (None, msg)

        response = self._session.get(f'https://api.telegram.org/bot{self._token}/sendPhoto', files=multipart_form_data,
                                     verify=False)

        if not response.json()['ok'] and response.json().get('description') == ERROR_CAPTION_TOO_LONG:
            # отправляем картинку и текст отдельно
            photo_msg_id = self.send_photo(photo, None, chat_id)
            self.send_message(msg, chat_id, photo_msg_id)  # в ответ на сообщение с фотографией
            return -1

        if not response.json()['ok']:
            logger.error(response.json())
            return -1

        return response.json()['result']['message_id']

    def send_photo_batch(self, photo, msg, chat_ids):
        for chat_id in chat_ids:
            self.send_photo(photo, msg, chat_id)
