from business_models import greenplum


def _iterate_flat_dict(d, prefix='', sep='_'):
    for key, value in d.items():
        assert isinstance(key, str)
        if isinstance(value, dict):
            yield from _iterate_flat_dict(value, prefix=f'{key}{sep}')
        else:
            yield f'{prefix}{key}', value


def flatten_dict(d, sep='_'):
    """
    Flattens nested dicts to one level:
    { 'a': { 'b' : { 'c' : 0 }}, 'd': 1 } -> { 'a_b_c' : 0, 'd': 1}
    """
    return dict(_iterate_flat_dict(d, sep=sep))


def run_sql(sql_file):
    print(f'Running SQL {sql_file} ...')
    with open(sql_file) as f:
        return greenplum(f.read())
