/*
    Author: @ikhomyanin

    Ticket: https://st.yandex-team.ru/LOGDATA-2853
*/


use hahn;

$LEADS = '//home/taxi-delivery/analytics/production/corp_client_funnel/leads';
$SAVE_TO = '//home/taxi-delivery/analytics/production/corp_client_funnel/ndd_lead_stages';

$leap_duration = ($init, $next) -> {
    $duration = case 
        when $init = "1. Идея" and $next = "1. Идея" then 0
        when $init = "1. Идея" and $next = "2. Провести встречу" then 1
        when $init = "1. Идея" and $next = "3. Переговоры" then 2
        when $init = "1. Идея" and $next = "4. Заключение договора" then 3
        when $init = "1. Идея" and $next = "5. Старт" then 4
        when $init = "1. Идея" and $next = "6. Разгон" then 5
        when $init = "1. Идея" and $next = "7. Развитие" then 6
        when $init = "1. Идея" and $next = "8. Удержание" then 7
        when $init = "1. Идея" and $next = "Проигрыш" then 1

        when $init = "2. Провести встречу" and $next = "1. Идея" then 1
        when $init = "2. Провести встречу" and $next = "2. Провести встречу" then 0
        when $init = "2. Провести встречу" and $next = "3. Переговоры" then 1
        when $init = "2. Провести встречу" and $next = "4. Заключение договора" then 2
        when $init = "2. Провести встречу" and $next = "5. Старт" then 3
        when $init = "2. Провести встречу" and $next = "6. Разгон" then 4
        when $init = "2. Провести встречу" and $next = "7. Развитие" then 5
        when $init = "2. Провести встречу" and $next = "8. Удержание" then 6
        when $init = "2. Провести встречу" and $next = "Проигрыш" then 1

        when $init = "3. Переговоры" and $next = "1. Идея" then 1
        when $init = "3. Переговоры" and $next = "2. Провести встречу" then 1
        when $init = "3. Переговоры" and $next = "3. Переговоры" then 0
        when $init = "3. Переговоры" and $next = "4. Заключение договора" then 1
        when $init = "3. Переговоры" and $next = "5. Старт" then 2
        when $init = "3. Переговоры" and $next = "6. Разгон" then 3
        when $init = "3. Переговоры" and $next = "7. Развитие" then 4
        when $init = "3. Переговоры" and $next = "8. Удержание" then 5
        when $init = "3. Переговоры" and $next = "Проигрыш" then 1

        when $init = "4. Заключение договора" and $next = "1. Идея" then 1
        when $init = "4. Заключение договора" and $next = "2. Провести встречу" then 1
        when $init = "4. Заключение договора" and $next = "3. Переговоры" then 1
        when $init = "4. Заключение договора" and $next = "4. Заключение договора" then 0
        when $init = "4. Заключение договора" and $next = "5. Старт" then 1
        when $init = "4. Заключение договора" and $next = "6. Разгон" then 2
        when $init = "4. Заключение договора" and $next = "7. Развитие" then 3
        when $init = "4. Заключение договора" and $next = "8. Удержание" then 4
        when $init = "4. Заключение договора" and $next = "Проигрыш" then 1

        when $init = "5. Старт" and $next = "1. Идея" then 1
        when $init = "5. Старт" and $next = "2. Провести встречу" then 1
        when $init = "5. Старт" and $next = "3. Переговоры" then 1
        when $init = "5. Старт" and $next = "4. Заключение договора" then 1
        when $init = "5. Старт" and $next = "5. Старт" then 0
        when $init = "5. Старт" and $next = "6. Разгон" then 1
        when $init = "5. Старт" and $next = "7. Развитие" then 2
        when $init = "5. Старт" and $next = "8. Удержание" then 3
        when $init = "5. Старт" and $next = "Проигрыш" then 1

        when $init = "6. Разгон" and $next = "1. Идея" then 1
        when $init = "6. Разгон" and $next = "2. Провести встречу" then 1
        when $init = "6. Разгон" and $next = "3. Переговоры" then 1
        when $init = "6. Разгон" and $next = "4. Заключение договора" then 1
        when $init = "6. Разгон" and $next = "5. Старт" then 1
        when $init = "6. Разгон" and $next = "6. Разгон" then 0
        when $init = "6. Разгон" and $next = "7. Развитие" then 1
        when $init = "6. Разгон" and $next = "8. Удержание" then 2
        when $init = "6. Разгон" and $next = "Проигрыш" then 1

        when $init = "7. Развитие" and $next = "1. Идея" then 1
        when $init = "7. Развитие" and $next = "2. Провести встречу" then 1
        when $init = "7. Развитие" and $next = "3. Переговоры" then 1
        when $init = "7. Развитие" and $next = "4. Заключение договора" then 1
        when $init = "7. Развитие" and $next = "5. Старт" then 1
        when $init = "7. Развитие" and $next = "6. Разгон" then 1
        when $init = "7. Развитие" and $next = "7. Развитие" then 0
        when $init = "7. Развитие" and $next = "8. Удержание" then 1
        when $init = "7. Развитие" and $next = "Проигрыш" then 1

        when $init = "8. Удержание" and $next = "1. Идея" then 1
        when $init = "8. Удержание" and $next = "2. Провести встречу" then 1
        when $init = "8. Удержание" and $next = "3. Переговоры" then 1
        when $init = "8. Удержание" and $next = "4. Заключение договора" then 1
        when $init = "8. Удержание" and $next = "5. Старт" then 1
        when $init = "8. Удержание" and $next = "6. Разгон" then 1
        when $init = "8. Удержание" and $next = "7. Развитие" then 1
        when $init = "8. Удержание" and $next = "8. Удержание" then 0
        when $init = "8. Удержание" and $next = "Проигрыш" then 1

        when $init = "Проигрыш" and $next = "1. Идея" then 1
        when $init = "Проигрыш" and $next = "2. Провести встречу" then 1
        when $init = "Проигрыш" and $next = "3. Переговоры" then 1
        when $init = "Проигрыш" and $next = "4. Заключение договора" then 1
        when $init = "Проигрыш" and $next = "5. Старт" then 1
        when $init = "Проигрыш" and $next = "6. Разгон" then 1
        when $init = "Проигрыш" and $next = "7. Развитие" then 1
        when $init = "Проигрыш" and $next = "8. Удержание" then 1
        when $init = "Проигрыш" and $next = "Проигрыш" then 0

        when $next is null then 1
        else 0
    end;

    return $duration;
};

$is_reverse = ($init, $next) -> {
    $duration = case 
        when $init = "1. Идея" and $next = "1. Идея" then false
        when $init = "1. Идея" and $next = "2. Провести встречу" then false
        when $init = "1. Идея" and $next = "3. Переговоры" then false
        when $init = "1. Идея" and $next = "4. Заключение договора" then false
        when $init = "1. Идея" and $next = "5. Старт" then false
        when $init = "1. Идея" and $next = "6. Разгон" then false
        when $init = "1. Идея" and $next = "7. Развитие" then false
        when $init = "1. Идея" and $next = "8. Удержание" then false
        when $init = "1. Идея" and $next = "Проигрыш" then false

        when $init = "2. Провести встречу" and $next = "1. Идея" then true
        when $init = "2. Провести встречу" and $next = "2. Провести встречу" then false
        when $init = "2. Провести встречу" and $next = "3. Переговоры" then false
        when $init = "2. Провести встречу" and $next = "4. Заключение договора" then false
        when $init = "2. Провести встречу" and $next = "5. Старт" then false
        when $init = "2. Провести встречу" and $next = "6. Разгон" then false
        when $init = "2. Провести встречу" and $next = "7. Развитие" then false
        when $init = "2. Провести встречу" and $next = "8. Удержание" then false
        when $init = "2. Провести встречу" and $next = "Проигрыш" then false

        when $init = "3. Переговоры" and $next = "1. Идея" then true
        when $init = "3. Переговоры" and $next = "2. Провести встречу" then true
        when $init = "3. Переговоры" and $next = "3. Переговоры" then false
        when $init = "3. Переговоры" and $next = "4. Заключение договора" then false
        when $init = "3. Переговоры" and $next = "5. Старт" then false
        when $init = "3. Переговоры" and $next = "6. Разгон" then false
        when $init = "3. Переговоры" and $next = "7. Развитие" then false
        when $init = "3. Переговоры" and $next = "8. Удержание" then false
        when $init = "3. Переговоры" and $next = "Проигрыш" then false

        when $init = "4. Заключение договора" and $next = "1. Идея" then true
        when $init = "4. Заключение договора" and $next = "2. Провести встречу" then true
        when $init = "4. Заключение договора" and $next = "3. Переговоры" then true
        when $init = "4. Заключение договора" and $next = "4. Заключение договора" then false
        when $init = "4. Заключение договора" and $next = "5. Старт" then false
        when $init = "4. Заключение договора" and $next = "6. Разгон" then false
        when $init = "4. Заключение договора" and $next = "7. Развитие" then false
        when $init = "4. Заключение договора" and $next = "8. Удержание" then false
        when $init = "4. Заключение договора" and $next = "Проигрыш" then false

        when $init = "5. Старт" and $next = "1. Идея" then true
        when $init = "5. Старт" and $next = "2. Провести встречу" then true
        when $init = "5. Старт" and $next = "3. Переговоры" then true
        when $init = "5. Старт" and $next = "4. Заключение договора" then true
        when $init = "5. Старт" and $next = "5. Старт" then false
        when $init = "5. Старт" and $next = "6. Разгон" then false
        when $init = "5. Старт" and $next = "7. Развитие" then false
        when $init = "5. Старт" and $next = "8. Удержание" then false
        when $init = "5. Старт" and $next = "Проигрыш" then false

        when $init = "6. Разгон" and $next = "1. Идея" then true
        when $init = "6. Разгон" and $next = "2. Провести встречу" then true
        when $init = "6. Разгон" and $next = "3. Переговоры" then true
        when $init = "6. Разгон" and $next = "4. Заключение договора" then true
        when $init = "6. Разгон" and $next = "5. Старт" then true
        when $init = "6. Разгон" and $next = "6. Разгон" then false
        when $init = "6. Разгон" and $next = "7. Развитие" then false
        when $init = "6. Разгон" and $next = "8. Удержание" then false
        when $init = "6. Разгон" and $next = "Проигрыш" then false

        when $init = "7. Развитие" and $next = "1. Идея" then true
        when $init = "7. Развитие" and $next = "2. Провести встречу" then true
        when $init = "7. Развитие" and $next = "3. Переговоры" then true
        when $init = "7. Развитие" and $next = "4. Заключение договора" then true
        when $init = "7. Развитие" and $next = "5. Старт" then true
        when $init = "7. Развитие" and $next = "6. Разгон" then true
        when $init = "7. Развитие" and $next = "7. Развитие" then false
        when $init = "7. Развитие" and $next = "8. Удержание" then false
        when $init = "7. Развитие" and $next = "Проигрыш" then false

        when $init = "8. Удержание" and $next = "1. Идея" then true
        when $init = "8. Удержание" and $next = "2. Провести встречу" then true
        when $init = "8. Удержание" and $next = "3. Переговоры" then true
        when $init = "8. Удержание" and $next = "4. Заключение договора" then true
        when $init = "8. Удержание" and $next = "5. Старт" then true
        when $init = "8. Удержание" and $next = "6. Разгон" then true
        when $init = "8. Удержание" and $next = "7. Развитие" then true
        when $init = "8. Удержание" and $next = "8. Удержание" then false
        when $init = "8. Удержание" and $next = "Проигрыш" then false

        when $init = "Проигрыш" and $next = "1. Идея" then false
        when $init = "Проигрыш" and $next = "2. Провести встречу" then false
        when $init = "Проигрыш" and $next = "3. Переговоры" then false
        when $init = "Проигрыш" and $next = "4. Заключение договора" then false
        when $init = "Проигрыш" and $next = "5. Старт" then false
        when $init = "Проигрыш" and $next = "6. Разгон" then false
        when $init = "Проигрыш" and $next = "7. Развитие" then false
        when $init = "Проигрыш" and $next = "8. Удержание" then false
        when $init = "Проигрыш" and $next = "Проигрыш" then false

        when $next is null then false
        else true
    end;

    return $duration;
};

$skipped_stages = ($init, $next) -> {
    $stages = [
        "1. Идея"
        , "2. Провести встречу"
        , "3. Переговоры"
        , "4. Заключение договора"
        , "5. Старт"
        , "6. Разгон"
        , "7. Развитие"
        , "8. Удержание"
        , "NO STATUS"
        , "Проигрыш"
    ];

    $stages_from_init = ListSkipWhile($stages, ($x) -> {return $x != $init});
    $stages_before_next = ListTakeWhile($stages_from_init, ($x) -> {return $x != $next});

    $all_stages = case 
        when $next is null then AsList($init)
        else ListExtend($stages_before_next, AsList($next))
    end;

    $first_stage = ListHead($all_stages);

    $shifted_stages = ListSkipWhile($all_stages, ($x) -> {return $x = $first_stage});

    $zipped_stages = ListZip($all_stages, $shifted_stages);

    $answer = case
        when ($next is null OR $next = 'Проигрыш' OR $leap_duration($init, $next) = 1) then ListZip(AsList($init), AsList($next))
        else $zipped_stages
    end; 

    return $answer;
};

$WRONG_STATUSES = (
    'NO STATUS'
    , 'UNKNOWN STATUS'
    , 'WRONG STATUS'
);

$ndd_leads = (
    select lead_id
        , lead_name
        , lead_responsible_user_group_name
        , lead_responsible_user_name
        , clean_company_city
        , clean_company_market_segment
        , clean_lead_ndd_funnel_stage
        , lead_acquisition_channel
        , lead_pipeline_name
        , lead_ndd_loss_reason
        , lead_payment_method
        , lead_status_name
        , clean_lead_ndd_potential_per_day
        , clean_lead_ndd_potential_per_month
        , lead_tags_list
        , lead_ndd_wishlist
        , utc_dt
    from $LEADS
    where 1=1
        and ndd_flg
);

$leads_w = (
    select l.lead_id as lead_id
        , if(l.clean_lead_ndd_funnel_stage not in $WRONG_STATUSES, l.clean_lead_ndd_funnel_stage, '1. Идея') as clean_lead_ndd_funnel_stage
        , l.utc_dt as utc_dt
        , if(
            some(clean_lead_ndd_funnel_stage) over (partition by lead_id order by utc_dt ROWS BETWEEN 1 FOLLOWING AND 1 FOLLOWING) not in $WRONG_STATUSES or some(clean_lead_ndd_funnel_stage) over (partition by lead_id order by utc_dt ROWS BETWEEN 1 FOLLOWING AND 1 FOLLOWING) is null
            , some(clean_lead_ndd_funnel_stage) over (partition by lead_id order by utc_dt ROWS BETWEEN 1 FOLLOWING AND 1 FOLLOWING)
            , '1. Идея'
         ) as next_funnel_stage
        , some(utc_dt) over (partition by lead_id order by utc_dt ROWS BETWEEN 1 FOLLOWING AND 1 FOLLOWING) as next_date
        , min(utc_dt) over w as first_utc_dt
        , max(utc_dt) over w as last_utc_dt
        , ROW_NUMBER() over (partition by lead_id order by utc_dt) as row_num
        , max_by(lead_name, utc_dt) over w as lead_name
        , max_by(lead_responsible_user_group_name, utc_dt) over w as lead_responsible_user_group_name
        , max_by(lead_responsible_user_name, utc_dt) over w as lead_responsible_user_name
        , max_by(clean_company_city, utc_dt) over w as clean_company_city
        , max_by(clean_company_market_segment, utc_dt) over w as clean_company_market_segment
        , max_by(lead_acquisition_channel, utc_dt) over w as lead_acquisition_channel
        , max_by(lead_pipeline_name, utc_dt) over w as lead_pipeline_name
        , max_by(clean_lead_ndd_funnel_stage, utc_dt) over w as current_clean_lead_ndd_funnel_stage
        , max_by(lead_ndd_loss_reason, utc_dt) over w as lead_ndd_loss_reason
        , max_by(lead_payment_method, utc_dt) over w as lead_payment_method
        , max_by(lead_status_name, utc_dt) over w as lead_status_name
        , max_by(clean_lead_ndd_potential_per_day, utc_dt) over w as clean_lead_ndd_potential_per_day
        , max_by(clean_lead_ndd_potential_per_month, utc_dt) over w as clean_lead_ndd_potential_per_month
        , max_by(lead_tags_list, utc_dt) over w as lead_tags_list
        , max_by(lead_ndd_wishlist, utc_dt) over w as lead_ndd_wishlist
    from $ndd_leads as l
    WINDOW w AS (
        PARTITION BY lead_id
    )
);

$leads_w_processed = (
    select *
    from $leads_w
    where 1=1
        and (
            clean_lead_ndd_funnel_stage != next_funnel_stage
            or 
            next_funnel_stage is null
        )
);

$stage_durations = (
    SELECT l.lead_id as lead_id 
        , l.lead_name as lead_name
        , l.lead_responsible_user_group_name as lead_responsible_user_group_name
        , l.lead_responsible_user_name as lead_responsible_user_name
        , l.clean_company_city as clean_company_city
        , l.clean_company_market_segment as clean_company_market_segment
        , l.lead_acquisition_channel as lead_acquisition_channel
        , l.lead_pipeline_name as lead_pipeline_name
        , l.current_clean_lead_ndd_funnel_stage as current_clean_lead_ndd_funnel_stage
        , l.lead_ndd_loss_reason as lead_ndd_loss_reason
        , l.lead_payment_method as lead_payment_method
        , l.lead_status_name as lead_status_name
        , l.clean_lead_ndd_potential_per_day as clean_lead_ndd_potential_per_day
        , l.clean_lead_ndd_potential_per_month as clean_lead_ndd_potential_per_month
        , l.lead_tags_list as lead_tags_list
        , l.lead_ndd_wishlist as lead_ndd_wishlist

        , l.clean_lead_ndd_funnel_stage as init_stage 
        , l.utc_dt as stage_end_dt
        , cast(cast(l.utc_dt as Date) - Interval('P1D')*(l.row_num - coalesce(some(row_num) over (partition by lead_id order by utc_dt ROWS BETWEEN 1 PRECEDING AND 1 PRECEDING), 0) - 1) as String) as stage_start_dt
        , l.next_funnel_stage as next_stage 
        , l.row_num - coalesce(some(row_num) over (partition by lead_id order by utc_dt ROWS BETWEEN 1 PRECEDING AND 1 PRECEDING), 0) as duration
        , if(l.clean_lead_ndd_funnel_stage in $WRONG_STATUSES, true, false) as from_wrong_status_flg
    from $leads_w_processed as l
);

$stage_durations_processed = (
    select sd.*
        , $leap_duration(sd.init_stage, sd.next_stage) as leap_duration
        , $skipped_stages(sd.init_stage, sd.next_stage) as skipped_stages
    from $stage_durations as sd 
    where 1=1
        and duration != 0
);

$stage_durations_processed_flattened = (
    select *
    from $stage_durations_processed
    flatten by skipped_stages
);

$almost_final = (
    select t1.lead_id as lead_id

        , t1.lead_name as lead_name
        , t1.lead_responsible_user_group_name as lead_responsible_user_group_name
        , t1.lead_responsible_user_name as lead_responsible_user_name
        , t1.clean_company_city as clean_company_city
        , t1.clean_company_market_segment as clean_company_market_segment
        , t1.lead_acquisition_channel as lead_acquisition_channel
        , t1.lead_pipeline_name as lead_pipeline_name
        , t1.current_clean_lead_ndd_funnel_stage as current_clean_lead_ndd_funnel_stage
        , t1.lead_ndd_loss_reason as lead_ndd_loss_reason
        , t1.lead_payment_method as lead_payment_method
        , t1.lead_status_name as lead_status_name
        , t1.clean_lead_ndd_potential_per_day as clean_lead_ndd_potential_per_day
        , t1.clean_lead_ndd_potential_per_month as clean_lead_ndd_potential_per_month
        , t1.lead_tags_list as lead_tags_list
        , t1.lead_ndd_wishlist as lead_ndd_wishlist

        , t1.init_stage as init_stage_q
        , t1.next_stage as next_stage_q
        , t1.stage_start_dt as stage_start_dt
        , t1.stage_end_dt as stage_end_dt
        , t1.skipped_stages.0 as init_stage
        , t1.skipped_stages.1 as next_stage
        , 1.0*t1.duration / t1.leap_duration as stage_duration
        , $is_reverse(t1.skipped_stages.0, t1.skipped_stages.1) as is_reverse_flg
        , if(t1.skipped_stages.0 = 'Проигрыш', true, false) as from_loss_flg
    from $stage_durations_processed_flattened as t1
);

insert into $SAVE_TO WITH TRUNCATE 
select t1.*
    , cast(cast(t1.stage_start_dt as Date) + Interval('P1D')*(cast(sum(stage_duration) over (partition by lead_id, init_stage_q, next_stage_q order by stage_start_dt) - t1.stage_duration as Int32)) as String) as stage_start_dt
    , cast(cast(t1.stage_start_dt as Date) + Interval('P1D')*(cast(sum(stage_duration) over (partition by lead_id, init_stage_q, next_stage_q order by stage_start_dt) as Int32) - 1) as String) as stage_end_dt
without t1.init_stage_q
    , t1.next_stage_q
    , t1.stage_start_dt
    , t1.stage_end_dt
from $almost_final as t1;
