use hahn;  

$ndd_lead_stages = '//home/taxi-delivery/analytics/production/corp_client_funnel/ndd_lead_stages';
$SAVE_TO_ndd_lead_stages_funnel = '//home/taxi-delivery/analytics/production/corp_client_funnel/ndd_lead_stages_funnel';

$ndd_lead_stages_info = 
    (select 
        lead_id 
        , min(stage_start_dt) as min_stage_end_dt
        , max_by(clean_company_city, stage_end_dt) as clean_company_city
        , max_by(clean_company_market_segment, stage_end_dt) as clean_company_market_segment
        , max_by(clean_lead_ndd_potential_per_day, stage_end_dt) as clean_lead_ndd_potential_per_day
        , max_by(clean_lead_ndd_potential_per_month, stage_end_dt) as clean_lead_ndd_potential_per_month
        , max_by(from_loss_flg, stage_end_dt) as from_loss_flg
        , max_by(lead_acquisition_channel, stage_end_dt) as lead_acquisition_channel
        , max_by(lead_name, stage_end_dt) as lead_name
        , max_by(lead_ndd_loss_reason, stage_end_dt) as lead_ndd_loss_reason
        , max_by(lead_ndd_wishlist, stage_end_dt) as lead_ndd_wishlist
        , max_by(lead_payment_method, stage_end_dt) as lead_payment_method
        , max_by(lead_pipeline_name, stage_end_dt) as lead_pipeline_name
        , max_by(lead_responsible_user_group_name, stage_end_dt) as lead_responsible_user_group_name
        , max_by(lead_responsible_user_name, stage_end_dt) as lead_responsible_user_name
        , max_by(lead_status_name, stage_end_dt) as lead_status_name
        , max_by(lead_tags_list, stage_end_dt) as lead_tags_list
        , min(if(COALESCE(init_stage = '1. Идея', next_stage = '1. Идея'), MIN_OF(stage_start_dt, stage_end_dt), null)) as start_dt_1
        , min(if(COALESCE(init_stage = '2. Провести встречу', next_stage = '2. Провести встречу'), MIN_OF(stage_start_dt, stage_end_dt), null)) as start_dt_2
        , min(if(COALESCE(init_stage = '3. Переговоры', next_stage = '3. Переговоры'), MIN_OF(stage_start_dt, stage_end_dt), null)) as start_dt_3
        , min(if(COALESCE(init_stage = '4. Заключение договора', next_stage = '4. Заключение договора'), MIN_OF(stage_start_dt, stage_end_dt), null)) as start_dt_4
        , min(if(COALESCE(init_stage = '5. Старт', next_stage = '5. Старт'), MIN_OF(stage_start_dt, stage_end_dt), null)) as start_dt_5
        , min(if(COALESCE(init_stage = '6. Разгон', next_stage = '6. Разгон'), MIN_OF(stage_start_dt, stage_end_dt), null)) as start_dt_6
        , min(if(COALESCE(init_stage = '7. Развитие', next_stage = '7. Развитие'), MIN_OF(stage_start_dt, stage_end_dt), null)) as start_dt_7
        , min(if(COALESCE(init_stage = '8. Удержание', next_stage = '8. Удержание'), MIN_OF(stage_start_dt, stage_end_dt), null)) as start_dt_8
        , min(if(COALESCE(init_stage = 'Проигрыш', next_stage = 'Проигрыш'), MIN_OF(stage_start_dt, stage_end_dt), null)) as start_dt_loss
        
    from $ndd_lead_stages 
    where is_reverse_flg = False
    group by lead_id);


INSERT INTO $SAVE_TO_ndd_lead_stages_funnel WITH TRUNCATE 

SELECT 
    lead_id
    , min_stage_end_dt
    , clean_company_city
    , clean_company_market_segment
    , clean_lead_ndd_potential_per_day
    , clean_lead_ndd_potential_per_month
    , from_loss_flg
    , lead_acquisition_channel
    , lead_name
    , lead_ndd_loss_reason
    , lead_ndd_wishlist
    , lead_payment_method
    , lead_pipeline_name
    , lead_responsible_user_group_name
    , lead_responsible_user_name
    , lead_status_name
    , lead_tags_list
    , COALESCE(start_dt_1, start_dt_2, start_dt_3, start_dt_4, start_dt_5, start_dt_6, start_dt_7, start_dt_8) as start_dt_1
    , COALESCE(start_dt_2, start_dt_3, start_dt_4, start_dt_5, start_dt_6, start_dt_7, start_dt_8) as start_dt_2
    , COALESCE(start_dt_3, start_dt_4, start_dt_5, start_dt_6, start_dt_7, start_dt_8) as start_dt_3
    , COALESCE(start_dt_4, start_dt_5, start_dt_6, start_dt_7, start_dt_8) as start_dt_4
    , COALESCE(start_dt_5, start_dt_6, start_dt_7, start_dt_8) as start_dt_5
    , COALESCE(start_dt_6, start_dt_7, start_dt_8) as start_dt_6
    , COALESCE(start_dt_7, start_dt_8) as start_dt_7
    , start_dt_8
    , start_dt_loss
    , case
        when start_dt_8 is not null and start_dt_loss is not null then '8.Проигрыш на стадии Удержание'
        when start_dt_7 is not null and start_dt_loss is not null then '7.Проигрыш на стадии Развитие'
        when start_dt_6 is not null and start_dt_loss is not null then '6.Проигрыш на стадии Разгон'
        when start_dt_5 is not null and start_dt_loss is not null then '5.Проигрыш на стадии Старт'
        when start_dt_4 is not null and start_dt_loss is not null then '4.Проигрыш на стадии Заключение договора'
        when start_dt_3 is not null and start_dt_loss is not null then '3.Проигрыш на стадии Переговоры'
        when start_dt_2 is not null and start_dt_loss is not null then '2.Проигрыш на стадии Провести встречу'
        when start_dt_1 is not null and start_dt_loss is not null then '1.Проигрыш на стадии Идея'
        when start_dt_1 is null and start_dt_loss is not null then '0.Сразу проигран'
        else NULL
    end as stage_of_loss

from $ndd_lead_stages_info;

