# -*- coding: utf-8 -*-
from nile.api.v1 import clusters

from projects.common.nile import environment as penv


def prepare_environment(
        obj, extra_requirements=[], parallel_operations_limit=None,
):
    return penv.configure_environment(
        obj,
        extra_requirements=extra_requirements,
        parallel_operations_limit=parallel_operations_limit,
    )


def get_project_cluster(
        parallel_operations_limit=None,
        extra_requirements=[],
        proxy=penv.DEFAULT_CLUSTER,
        use_yql=False,
        pool='',
):
    if use_yql:
        cluster = clusters.yql.YQLProduction(proxy=proxy, pool=pool)
    else:
        cluster = clusters.yt.YT(proxy=proxy, pool=pool)
    return prepare_environment(
        cluster,
        extra_requirements=extra_requirements,
        parallel_operations_limit=parallel_operations_limit,
    )
