import sys
import pandas as pd
import numpy as np
from business_models import hahn

if __name__=='__main__':
    # Репликация
    # part = greenplum('select * from snb_taxi.ravaev_b2b_org_name')
    # hahn.write(part, 'home/taxi-analytics/nbobukh/express/demand/corp_client_name')

    # Выбор месяцев для обновления
    months = pd.date_range('2021-01-01',
                           pd.Timestamp.today().strftime('%Y-%m-%d'),
                           freq='MS')
    compare_date = pd.Timestamp.today() - pd.Timedelta(days=2)
    update_dt = [x.strftime('%Y-%m-%d') for x in months if x.month >= compare_date.month]

    # Для записи ошибок
    message_list = []

    # Запуск расчетов и проверка на ошибки
    with open('yt_orders_query.sql', 'r') as reader:
        query = reader.read()
    for dt in update_dt:
        try:
            hahn(query.format(dt), syntax_version=1)
        except RequestException:
            message_list.append(('''
            1. Query Date - {0}
            Query Error
            '''.format(dt), False))
        except:
            exc_type, exc_val, traceback = sys.exc_info()
            message_list.append(('''
            1. Query Date - {0}
            Query Error:{1}
            Value:{2}
            '''.format(dt, str(exc_type), str(exc_val)), False))
        else:
            message_list.append(('1. Query Date - {0}\nYT Query done', True))

    print('Done')