pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$parse = DateTime::Parse('%Y-%m-%d %H:%M:%S');
$parse_dt = DateTime::Parse('%Y-%m-%d');
$format_dt = DateTime::Format('%Y-%m-%d');
$mdb_orders = 'home/taxi-dwh/ods/mdb/order/' || '{0}';
$dm_order = 'home/taxi-dwh/summary/dm_order/' || substring('{0}', 0, 7);
$order_proc_raw = '//home/taxi-dwh/raw/mdb/order_proc/' || '{0}';
$place_to_save = 'home/taxi-analytics/nbobukh/express/demand/orders/' || '{0}';
$month_ago = $format_dt(DateTime::StartOfMonth(DateTime::MakeDate($parse_dt('{0}')) - DateTime::IntervalFromDays(1)));

$geo = (
select  tariff_zone,
        name_ru as city_ru
from `//home/taxi-dwh/cdm/geo/v_dim_op_geo_hierarchy/v_dim_op_geo_hierarchy`
where node_type = 'agglomeration'
);

$mdb_1 = (
select  order_id,
        reorder_cnt,
        DateTime::ToSeconds(DateTime::MakeDatetime($parse(utc_order_due_dttm))) as ts_order_due_dttm,
        DateTime::ToSeconds(DateTime::MakeDatetime($parse(utc_start_waiting_dttm))) as ts_start_waiting_dttm,
        DateTime::ToSeconds(DateTime::MakeDatetime($parse(utc_start_transporting_dttm))) as ts_start_transporting
from $mdb_orders
);

$mdb_orders = (
select  order_id,
        reorder_cnt,
        if(
            max_of(ts_start_waiting_dttm, ts_order_due_dttm) > ts_start_transporting,
            0,
            ts_start_transporting - max_of(ts_start_waiting_dttm, ts_order_due_dttm)) as wait_a_sec
from $mdb_1
);

$dm_order = (
select  order_id, 
        success_order_flg,
        expired_order_flg,
        fake_order_flg,
        fraud_order_flg,
        mqc_order_flg,
        order_type,
        order_tariff,
        local_order_dttm,
        utc_order_dttm,
        moscow_order_dttm,
        corp_client_id,
        coop_account_type,
        corp_order_flg,
        order_source,
        tariff_zone,
        taxi_status,
        status,
        corp_contract_id,
        driver_id,
        unique_driver_id,
        first_order_flg,
        currency_rate,
        payment_type,
        corp_client_name,
        driver_license_normalized,
        order_cost,
        net_inflow,
        user_phone_id,
        user_id,
        application_platform,
        (corp_client_id is not null) as b2b_flg,
        (status = 'cancelled' and driver_id is null) as user_cancell_before_assign,
        (status = 'cancelled' and driver_id is not null) as user_cancell_after_assign,
        Yson::ConvertToString(order_requirements.cargo_loaders) ?? '0' as cargo_loaders,
        Yson::ConvertToString(order_requirements.cargo_type) ?? 'not_specified' as cargo_type,
        cast(Yson::ConvertToString(order_requirements.door_to_door) as bool) ?? False as door_to_door,
        DateTime::ToSeconds(
            DateTime::MakeDatetime($parse(utc_order_status_updated_dttm)) - DateTime::MakeDatetime($parse(utc_order_dttm))
            ) as sec_expired
from $dm_order
where order_tariff in ('courier', 'express', 'cargo', 'cargocorp')
);

$corp_names = (
select  corp_contract_id,
        org_name,
        holding_name,
        top_100_delivery_flg
from `home/taxi-analytics/nbobukh/express/demand/corp_client_name`
);

$claim_orders = (
select  taxi_order_id as order_id,
        True as logistic_order_flg
from `//home/taxi/production/replica/postgres/cargo_claims/claims`
);

$order_proc = (
select  id as order_id,
        ListExtract(
            Yson::ConvertTo(    doc.order.virtual_tariffs[0].special_requirements, 
                                List<Struct<id:String>>), 
            "id") as tags_list,
        Yson::ConvertToStringList(doc.order.request.class) as request_class_list,
        Yson::ConvertToDouble(doc.order.calc_info.waiting_cost) as total_wait_cost,
        Yson::ConvertToDouble(doc.order.calc_info.waiting_time) as total_wait_sec,
        Yson::ConvertToDouble(doc.order.pricing_data.user.data.tariff.waiting_price.free_waiting_time) as free_waiting_time,
        Yson::ConvertToDouble(doc.order.pricing_data.user.data.tariff.waiting_price.price_per_minute) as price_per_minute
from $order_proc_raw);
    
$order_req = (
select 
    order_id,
    total_wait_cost,
    total_wait_sec,
    free_waiting_time,
    price_per_minute,
    (
        ListHas(request_class_list, 'courier') and 
        ListHas(request_class_list, 'express')) as folback_order,
    ListSort(tags_list) as supply_plan
    -- ListHas(tags_list, 'cargo_multipoints') as cargo_multipoints,
    -- ListHas(tags_list, 'cargo_eds') as cargo_eds,
    -- ListHas(tags_list, 'cargo_eds_for_cargo_tariff') as cargo_eds_for_cargo_tariff,
    -- ListHas(tags_list, 'approved_for_corporate_delivery_requirement') as approved_for_corporate_delivery_requirement,
    -- ListHas(tags_list, 'thermobag_delivery') as thermobag_delivery,
    -- ListHas(tags_list, 'car_couriers') as car_couriers,
    -- ListHas(tags_list, 'globus_project') as globus_project,
    -- ListHas(tags_list, 'leroymerlen_project') as leroymerlen_project
from 
    $order_proc
);

$supply_tags = (
select order_id,
    tariff_name,
    Yson::ConvertToString(req.id) as tag
from (
    select order_id,
        Yson::ConvertToString(tariff.class) as tariff_name,
        Yson::ConvertToList(tariff.special_requirements) as req_list
    from (
        select
            id as order_id,
            Yson::ConvertToList(doc.order.virtual_tariffs) as tariffs_list
        FROM $order_proc_raw
        where Yson::ConvertToList(doc.order.virtual_tariffs) is not null
    ) FLATTEN LIST BY tariffs_list as tariff
) FLATTEN LIST BY req_list as req      
);
        
$base =
(select distinct order_id
from $supply_tags
);

$courier =
(
select order_id, ListConcat(ListSort(AGGREGATE_LIST_DISTINCT(tag)), "; ") as courier_supply_plan
from $supply_tags
where tariff_name = 'courier'
GROUP BY order_id
)
;

$express =
(
select order_id, ListConcat(ListSort(AGGREGATE_LIST_DISTINCT(tag)), "; ") as express_supply_plan
from $supply_tags
where tariff_name = 'express'
GROUP BY order_id
)
;

$cargo_cargocorp =
(
select order_id, ListConcat(ListSort(AGGREGATE_LIST_DISTINCT(tag)), "; ") as cargo_supply_plan
from $supply_tags
where tariff_name in ('cargo', 'cargocorp')
GROUP BY order_id
)
;

$supply_plans =
(                            
select a.order_id as order_id
    , cargo_supply_plan as supply_plan_cargo
    , courier_supply_plan as supply_plan_courier
    , express_supply_plan as supply_plan_express
from $base as a
    left join $courier as b on a.order_id = b.order_id
    left join $express as c on a.order_id = c.order_id
    left join $cargo_cargocorp as d on a.order_id = d.order_id
)
;
        
        
$supply_type = (
Select  id,
        cand_driver_id,
        supply_type
From (  Select  id,
                ListZip(
                    ListMap(    Yson::ConvertToList(doc.candidates), 
                                ($x) -> {{Return Yson::ConvertToString($x.driver_id)}}),
                    ListMap(    Yson::ConvertToList(doc.candidates), 
                    ($x) -> {{Return Yson::ConvertToStringList($x.tags)}})
                    ) as candidates_data
From $order_proc_raw )
flatten list by candidates_data as cand
group by    id,
            cand.0 as cand_driver_id,
            Case    when ListHas(cand.1, "taxi_courier") then "taxi_courier"
                when ListHas(cand.1, "auto_courier") then "auto_courier"
                when ListHas(cand.1, "walking_courier") then "walking_courier"
            else "taxi_courier" end as supply_type
);

$candidates = (
select  order_id,
        count(*) as candidates_amount,
        count_if(
            candidate_status in ('reject_autocancel','reject_manual','offer_timeout')
            ) as candidates_skipped
from range(`home/taxi-dwh/export/rep_candidate_metric_v2`, $month_ago)
group by order_id
);

$newbies = (
Select  user_phone_id,
        order_tariff,
        min_by(order_id, utc_order_dttm) as first_order_id,
        true as new_in_tariff
From range(`//home/taxi-dwh/summary/dm_order`, `2019-06`)
where success_order_flg
and order_tariff in ('cargo', 'express', 'courier')
group by    user_phone_id, 
            order_tariff
);

insert into $place_to_save
with truncate
select  distinct -- из dm_order
        t1.order_id as order_id, 
        success_order_flg,
        expired_order_flg,
        order_type,
        t1.order_tariff as order_tariff,
        local_order_dttm,
        utc_order_dttm,
        t1.tariff_zone as tariff_zone,
        taxi_status,
        status,
        t1.corp_contract_id as corp_contract_id,
        corp_client_id,
        corp_order_flg,
        coop_account_type,
        order_source,
        currency_rate,
        b2b_flg,
        user_cancell_before_assign,
        user_cancell_after_assign,
        cargo_loaders,
        cargo_type,
        door_to_door,
        application_platform,
        driver_id,
        moscow_order_dttm,
        unique_driver_id,
        if(expired_order_flg and sec_expired < 15, True, False) as fake_orders,
        first_order_flg,
        t1.user_phone_id as user_phone_id,
        user_id,
        order_cost,
        net_inflow,
        fake_order_flg,
        fraud_order_flg,
        mqc_order_flg,
        payment_type,
        corp_client_name,
        driver_license_normalized,
        
        -- из mdb_order
        reorder_cnt,
        wait_a_sec,
        
        -- geo
        city_ru,
        
        -- order_proc
        total_wait_cost,
        total_wait_sec,
        free_waiting_time,
        price_per_minute,
        supply_plan,
        supply_plan_cargo,
        supply_plan_courier,
        supply_plan_express,
        -- cargo_multipoints,
        -- cargo_eds,
        -- cargo_eds_for_cargo_tariff,
        -- approved_for_corporate_delivery_requirement,
        -- thermobag_delivery,
        -- car_couriers,
        -- globus_project,
        -- leroymerlen_project,
        folback_order,
        
        -- supply type 
        supply_type,
        
        -- cargo cliams
        logistic_order_flg ?? False as logistic_order_flg,
        
        -- corp names
        org_name ?? '_c2c_client_' as org_name,
        holding_name ?? '_c2c_client_' as holding_name,
        top_100_delivery_flg ?? False as top_100_delivery_flg,
        
        -- candidates
        candidates_amount ?? 0 as candidates_amount,
        candidates_skipped ?? 0 as candidates_skipped,
        
        -- newbies
        new_in_tariff,
        
        -- доп
        if( expired_order_flg or success_order_flg or 
            user_cancell_before_assign or user_cancell_after_assign,
            False, True) as unknown_status,
        max_of(wait_a_sec - free_waiting_time, 0) as paid_wait_in_a,
        max_of(
            total_wait_sec - max_of(wait_a_sec - free_waiting_time, 0), 0) as paid_wait_in_road
from $dm_order as t1
join $mdb_orders as t2
on t1.order_id = t2.order_id
join $geo as t3
on t1.tariff_zone = t3.tariff_zone
join $order_req as t4
on t1.order_id = t4.order_id
left join $claim_orders as t5
on t1.order_id = t5.order_id
left join $corp_names as t6
on t1.corp_contract_id = t6.corp_contract_id
left join $candidates as t7
on t1.order_id = t7.order_id
left join $newbies as t8
on t1.order_id = t8.first_order_id
left join $supply_type as t9
on t1.driver_id = t9.cand_driver_id 
and t1.order_id = t9.id
left join $supply_plans as t10 
on t1.order_id = t10.order_id