
drop table if exists ndd_market_lavka;
create temporary table ndd_market_lavka as

select day, city, sum(deliveries) as deliveries
from (
         select msk_claim_created_dttm::date                                 as day,
                region_name                                                  as city,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_k2
         where pickup_or_lavka = 'lavka'
         group by 1, 2

         union all

         select msk_claim_created_dttm::date                                 as date,
                region_name                                                  as city,
                count(distinct market_order_id) filter (where confirmed_flg) as deliveries
         from snb_delivery.dash_ts a
         group by 1, 2
     ) as a
group by 1,2
;



drop table if exists ndd_deliveries;
CREATE TEMP TABLE ndd_deliveries as
select
    first_day as day,
    city,
    count (distinct request_id) as deliveries
from
    (
        select distinct
            request_id,
            corp_client_id,
            coalesce(delivery_country, 'Россия') as country,
            coalesce(geo.tz_aggl_name_ru, 'Москва') as city,
            first_value (tech_event_instant_ddtm) over (
                partition by request_id
                order by tech_event_instant_ddtm)::date as first_day
        from
            snb_delivery.logdata_ndd_requests_datamart a
            left join core_cdm_geo.v_dim_fi_geo_hierarchy geo
                on a.delivery_region = geo.geobase_id
        where
            mapped_event_type in ('Доставлен', 'Доставлен - подтверждено', 'Доставлен частично', 'Доставлен частично - подтверждено')
            and tech_event_instant_ddtm::date <= current_date - interval '1 day'
    ) ndd
group by
    1,2;



drop table if exists base;
create temporary table base as
SELECT
    date as day,
    corp_order_flg,
    country,
    city,
    case when tariff = 'K2' then 'Delivery+Courier' else tariff end::text as business,
    coalesce(case when client like 'Еда%' then 'Еда' else client end,
             case when manager_metagroup in ('Тир 1', 'Тир 2') then corp_client_name else 'Other' end
        ) as client,
    same_or_next_day,
    same_or_next_day_fake,
    sum(deliveries) as trips,
    sum(gmv) as gmv,
    sum(gmv) filter (where tariff_class_code in ('express', 'courier', 'ubernight')) as gmv_express,
    sum(gmv) filter (where tariff_class_code in ('cargo', 'cargocorp')) as gmv_cargo,
    sum(gmv) filter (where client like 'Еда%') as gmv_eda,
    sum(commissions) as commissions,
    sum(subsidies) as subsidies,
    sum(decoupling) as decoupling,
    sum(net_inflow) as net_inflow
FROM
    snb_delivery.data_bizdev a
where
    date >= current_date - interval '1 year' - interval '1 day'
group by
    1, 2, 3, 4, 5, 6, 7, 8;




drop table if exists base_share;
create temporary table base_share as
select
    *,
    gmv_express*1.0/sum(gmv_express) over (partition by day) as gmv_express_share,
    gmv_cargo*1.0/sum(gmv_cargo) over (partition by day) as gmv_cargo_share,
    gmv_eda*1.0/sum(gmv_eda) over (partition by day) as gmv_eda_share
from
    base;



drop table if exists data_fact;
create temporary table data_fact as

    select
        b.corp_order_flg,
        b.country,
        b.business,
        b.day,
        b.city,
        b.client,
        b.same_or_next_day,
        b.same_or_next_day_fake,
        b.trips,
        b.gmv,
        b.commissions,
        b.subsidies
            + coalesce(gmv_cargo_share,0) * 1.0 * coalesce(geo.expenses_cargo, 0)
            + coalesce(gmv_express_share,0) * 1.0 * coalesce(geo.express_courier_expenses, 0)
            as subsidies,
        b.decoupling
            - coalesce(gmv_eda_share,0) * 1.0 * coalesce(eda_exp.expenses_rub::integer, 0)
            as decoupling,
        b.net_inflow
            - coalesce(gmv_cargo_share,0) * 1.0 * coalesce(geo.expenses_cargo, 0)
            - coalesce(gmv_express_share,0) * 1.0 * coalesce(geo.express_courier_expenses, 0)
            - coalesce(gmv_eda_share,0) * 1.0 * coalesce(eda_exp.expenses_rub::integer, 0)
            as net_inflow
    from
        base_share as b
        left join snb_delivery.data_geosubs as geo
            on b.day = geo.dt::date
        left join snb_delivery.data_eda_expenses as eda_exp
            on b.day = eda_exp.day::date
;




drop table if exists daily;
create temporary table daily as

    select
        country,
        city,
        corp_order_flg,
        business,
        client,
        same_or_next_day,
        day,
        sum(trips) as trips,
        sum(gmv) as gmv,
        sum(commissions) as commissions,
        sum(subsidies) as subsidies,
        sum(decoupling) as decoupling,
        sum(net_inflow) as net_inflow
    from
        data_fact
    where
        same_or_next_day_fake in ('Same', 'Next_Pvz')
    group by
        1, 2, 3, 4, 5, 6, 7

    union all

    select
        'Россия' as country,
        city,
        True as corp_order_flg,
        'Delivery+Courier' as business,
        'Other' as client,
        'Next' as same_or_next_day,
        day,
        0 as trips,
        sum(gmv) as gmv,
        sum(commissions) as commissions,
        sum(subsidies) as subsidies,
        sum(decoupling) as decoupling,
        sum(net_inflow) as net_inflow
    from
        data_fact
    where
        same_or_next_day_fake = 'Next'
    group by
        1, 2, 3, 4, 5, 6, 7

    union all

    select
        'Россия' as country,
        city,
        True as corp_order_flg,
        'Delivery+Courier' as business,
        'Маркет' as client,
        'Next' as same_or_next_day,
        day,
        sum(deliveries) as trips,
        0 as gmv,
        0 as commissions,
        0 as subsidies,
        0 as decoupling,
        0 as net_inflow
    from
        ndd_market_lavka
    group by
        1, 2, 3, 4, 5, 6, 7

    union all

    select
        'Россия' as country,
        city,
        True as corp_order_flg,
        'Delivery+Courier' as business,
        'Other' as client,
        'Next' as same_or_next_day,
        day::date as day,
        sum(deliveries) as trips,
        0 as gmv,
        0 as commissions,
        0 as subsidies,
        0 as decoupling,
        0 as net_inflow
    from
        ndd_deliveries
    group by
        1, 2, 3, 4, 5, 6, 7
;



drop table if exists dash_finance_growth;
create temp table dash_finance_growth as
select
        unnest(array ['day','week','month']) as scale,
        unnest(array [day, date_trunc('week',day), date_trunc('month',day)]) as date,
        country,
        case
            when geo.population_group = 'RU_MSC' then 'Москва'
            when geo.population_group = 'RU_SPB' then 'Санкт-Петербург'
            else city
            end as city,
        case
            when country = 'Россия' then case
                when geo.population_group = 'RU_MSC' then 'Москва'
                when geo.population_group = 'RU_SPB' then 'Санкт-Петербург'
                when geo.population_group in ('RU_1M+', 'RU_300K+','RU_500K+') then geo.population_group
                when geo.population_group in ('RU_200K+','RU_100K+') then 'RU_100K+'
                else 'RU_100K-'
                end
            else case
                when geo.population_group like '%_1M+' or geo.population_group like '%_300K+' or geo.population_group like '%_500K+'
                    then 'INT_' || substr(geo.population_group,4,length(geo.population_group)-3)
                when geo.population_group like '%_200K+' or geo.population_group like '%_100K+'
                    then 'INT_100K+'
                else 'INT_100K-'
                end
            end as city_group,
        corp_order_flg,
        business,
        client,
        same_or_next_day,
        sum(trips)::float as trips,
        sum(gmv)::float as gmv,
        sum(commissions)::float as commissions,
        sum(subsidies)::float as subsidies,
        sum(decoupling)::float as decoupling,
        sum(net_inflow)::float as net_inflow
from daily a
    inner join (
        select distinct tz_aggl_name_ru, population_group
        from core_cdm_geo.v_dim_fi_geo_hierarchy
        where node_type = 'agglomeration'
    ) geo on geo.tz_aggl_name_ru = a.city
group by
    1,2,3,4,5,6,7,8,9
;


drop table if exists snb_delivery.dash_finance_growth;
create table snb_delivery.dash_finance_growth as

    SELECT
        scale,
        date::date as date,
        country,
        city,
        city_group,
        corp_order_flg,
        business,
        client,
        same_or_next_day,
        trips,
        gmv,
        commissions,
        subsidies,
        decoupling,
        net_inflow,
        lag(trips) over (partition by scale, country, city, city_group, corp_order_flg, business, client, same_or_next_day order by date) as trips_prev,
        lag(gmv) over (partition by scale, country, city, city_group, corp_order_flg, business, client, same_or_next_day order by date) as gmv_prev,
        lag(commissions) over (partition by scale, country, city, city_group, corp_order_flg, business, client, same_or_next_day order by date) as commissions_prev,
        lag(subsidies) over (partition by scale, country, city, city_group, corp_order_flg, business, client, same_or_next_day order by date) as subsidies_prev,
        lag(decoupling) over (partition by scale, country, city, city_group, corp_order_flg, business, client, same_or_next_day order by date) as decoupling_prev,
        lag(net_inflow) over (partition by scale, country, city, city_group, corp_order_flg, business, client, same_or_next_day order by date) as net_inflow_prev,
        date = max(date) over (partition by scale) as is_max_scale_date
    FROM
        dash_finance_growth
    where
        (scale = 'day' and date < date_trunc('day',current_date))
        or (scale = 'week' and date < date_trunc('week',current_date))
        or (scale = 'month' and date < date_trunc('month',current_date))
;

grant select, insert, delete, update, truncate, references
    on snb_delivery.dash_finance_growth
    to public, "robot-log-analytics";
