from business_models import hahn, greenplum
import pandas as pd
import numpy as np
import os



israel = greenplum("""


drop table if exists money;
create temp table money as
select
    order_id,
    order_cost as gmv_orig,
    order_cost * currency_rate as gmv,
    gross_commission_revenue_amt * currency_rate as commissions,
    incentives_amt * currency_rate as subsidies,
    b2b_decoupling_amt * currency_rate * case when decoupling_flg then 1 else 0 end as decoupling,
    net_inflow_amt * currency_rate as net_inflow
from
    taxi_cdm_marketplace.fct_order_metric
where
    utc_order_created_dttm >= timestamp'2022-04-01' AT TIME ZONE 'Europe/Moscow' AT TIME ZONE 'UTC'
    and tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp', 'ubernight', 'uberlux')
distributed by (order_id);
analyze money;


drop table if exists data_bizdev_orders;
CREATE temp TABLE data_bizdev_orders as
select
    fo.order_id,
    fo.park_client_name,
    (fo.utc_order_created_dttm + interval '3 hours')::date as order_date,
    fo.lcl_order_created_dt as local_date,
    fo.success_order_flg::int as success_order_flg,

    fo.delivery_point_cnt,


    coalesce(money.gmv, 0) as gmv,
    coalesce(money.gmv_orig, 0) as gmv_orig,
    coalesce(money.commissions, 0) as commissions,
    coalesce(money.subsidies, 0) as subsidies,
    coalesce(money.decoupling, 0) as decoupling,
    coalesce(money.net_inflow, 0) as net_inflow

from
    taxi_cdm_marketplace.fct_order as fo

    left join money
        on money.order_id = fo.order_id

    left join snb_delivery.self_orders so
        on so.order_id = fo.order_id

where
    fo.utc_order_created_dttm >= (timestamp'2022-04-01' AT TIME ZONE 'Europe/Moscow' AT TIME ZONE 'UTC')
    and (fo.tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp')
        or (fo.tariff_class_code = 'ubernight' and fo.utc_order_created_dttm >= '2021-09-01')
        or (fo.tariff_class_code = 'uberlux' and fo.utc_order_created_dttm >= '2022-03-01'))
    and not fo.fake_order_flg
    and not fo.mqc_order_flg
    and not fo.user_fraud_flg
    and so.order_id is null
    and fo.country_name_ru = 'Израиль'

DISTRIBUTED RANDOMLY;
ANALYZE data_bizdev_orders;

select order_date, sum(gmv_orig*success_order_flg) as gmv_orig, sum(gmv*success_order_flg) as gmv
from data_bizdev_orders
group by 1
order by 1

""")


israel.to_excel('israel.xlsx')



from business_models.startrek import StartrekWrapper

st = StartrekWrapper()

st.comment('DBI-168',
           text=u"Выгрузка готова",
           attachments='israel.xlsx',
           summonees=['kozlovaanna90'])


os.remove('israel.xlsx')
del(israel)
