import os
import yt.wrapper as yt
from datetime import datetime


def gen_resources(ytc, base):
    for name in ytc.list(base):
        path = yt.ypath_join(base, name)
        node_type = ytc.get_attribute(path, 'type')
        today = datetime.today().isoformat()
        if node_type == 'table':
            resources = ytc.get_attribute(path, 'recursive_resource_usage')
            yield dict(
                datetime=today,
                path=path,
                chunk_count=resources['chunk_count'],
                node_count=resources['node_count'],
                disk_space=sum(resources['disk_space_per_medium'].values()),
                access_time=ytc.get_attribute(path, 'access_time'),
                row_count=ytc.get_attribute(path, 'row_count', default=0),
                owner=ytc.get_attribute(path, 'owner'),
            )
        elif node_type == 'map_node':
            yield from gen_resources(ytc, path)

def main():
    ytc = yt.YtClient(token=os.environ['YT_TOKEN'], proxy='hahn.yt.yandex.net')
    out_table = '//home/taxi-delivery/analytics/resources'
    schema = [
        {'name': 'datetime', 'type': 'string', 'required': True},
        {'name': 'path', 'type': 'string', 'required': True},
        {'name': 'owner', 'type': 'string', 'required': True},
        {'name': 'access_time', 'type': 'string', 'required': True},
        {'name': 'chunk_count', 'type': 'int64', 'required': True},
        {'name': 'disk_space', 'type': 'int64', 'required': True},
        {'name': 'node_count', 'type': 'int64', 'required': True},
        {'name': 'row_count', 'type': 'int64', 'required': True},
    ]
    if not ytc.exists(out_table):
        ytc.create('table', out_table, force=True, attributes={'schema': schema, 'optimize_for': 'scan'})
    ytc.write_table(out_table, gen_resources(ytc, '//home/taxi-delivery/analytics'))

if __name__ == '__main__':
    main()