import os
import sys
import requests
import logging
from business_models import hahn

logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')
def pager(url, countries, entity, initial_page=1):
    for country in countries:
        session = requests.session()
        session.headers = {'Authorization': 'Auth %s' % country['token']}
        page = initial_page
        counter = 0
        while True:
            response = session.get(url+'/'+str(country['company_id'])+'/'+str(entity), params={'page': page})
            response.raise_for_status()
            result = response.json()
            if len(result) == 0:
                break
            for element in result:
                counter += 1
                yield element
                if not counter % 1000:
                    logging.info('Loaded %d results', counter)
            page += 1
        logging.info('Loaded %d results', counter)


def main():
    countries = [
        {
            # Chile
			'token': os.environ['ROUTING_CHILE_OAUTH'],
            'company_id': 35961
        },
        {
            # Serbia
			'token': os.environ['ROUTING_SERBIA_OAUTH'],
            'company_id': 44770
        },
        {
            # Serbia 2
			'token': os.environ['ROUTING_SERBIA_2_OAUTH'],
            'company_id': 46898
        },
        {
            # Turkey
			'token': os.environ['ROUTING_TURKEY_OAUTH'],
            'company_id': 44170
        },
        {
            # Peru
			'token': os.environ['ROUTING_PERU_OAUTH'],
            'company_id': 45758
        },
        {
            # Mexico 1
			'token': os.environ['ROUTING_MEXICO_1_OAUTH'],
            'company_id': 44815
        },
        {
            # Mexico 2
			'token': os.environ['ROUTING_MEXICO_2_OAUTH'],
            'company_id': 46151
        },
        {
            # Mexico 3
			'token': os.environ['ROUTING_MEXICO_3_OAUTH'],
            'company_id': 47310
        },
        {
            # UAE
			'token': os.environ['ROUTING_UAE_OAUTH'],
            'company_id': 46504
        },
        {
            # RSA 1
			'token': os.environ['ROUTING_RSA_1_OAUTH'],
            'company_id': 45155
        },
        {
            # RSA 2
			'token': os.environ['ROUTING_RSA_2_OAUTH'],
            'company_id': 46534
        }
    ]
    yt = hahn.yt
    for entity in ('orders', 'routes', 'couriers', 'users', 'depots'):
        logging.info('Loading %s', entity)
        gen = pager('https://courier.yandex.ru/api/v1/companies', countries, entity)
        yt.write_table(f'//home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/raw/{entity}', gen)

if __name__ == '__main__':
    main()
