-- Please note that YQL schema not specified, so we're telling YQL to infer it from data.
USE hahn;
PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA yt.InferSchema = '1';
PRAGMA yt.Owners = 'griganton';

$make_utc_dttm = ($t) -> (Datetime::Format('%Y-%m-%d %H:%M:%S')(DateTime::MakeDatetime(DateTime::ParseIso8601($t))));


INSERT INTO  `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/object/order`
WITH TRUNCATE
SELECT
    id as order_id,
    lat,
    lon,
    address,
    amount,
    company_id,
    customer_name,
    description,
    route_id,
    number as order_number,
    volume,
    weight,
    type,
    status,
    $make_utc_dttm (Yson::ConvertToString(time_window.start)) as utc_time_window_start_dttm,
    $make_utc_dttm (Yson::ConvertToString(time_window.end)) as utc_time_window_end_dttm,
FROM `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/raw/orders`;

INSERT INTO  `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/object/order_history`
WITH TRUNCATE
SELECT
    id as order_id,
    Yson::ConvertToString(record.event) as event,
    Yson::ConvertToString(record.status) as status,
    $make_utc_dttm (Yson::ConvertToString(record.time)) as utc_time_dttm,
    Yson::ConvertToString(record.source.initiator) as source_initiator,
    Yson::ConvertToString(record.source.user_role) as source_user_role,
    Yson::ConvertToDouble(record.position.lat) as position_lat,
    Yson::ConvertToDouble(record.position.lon) as position_lon,
    $make_utc_dttm (Yson::ConvertToString(record.position.time)) as position_time,
    Yson::ConvertToString(record.time_interval) as time_interval,
FROM `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/raw/orders`
FLATTEN BY (Yson::ConvertToList(history) as record)
;

INSERT INTO  `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/object/routes`
WITH TRUNCATE
SELECT
    `id` as route_id,
    `company_id`,
    `courier_id`,
    `courier_violated_route`,
    `date`,
    `depot_id`,
    `number`,
    `route_start`,
    `routing_mode`
FROM hahn.`home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/raw/routes`
;


INSERT INTO  `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/object/couriers`
WITH TRUNCATE
SELECT
    `company_id`,
    `id`,
    `name`,
    `number`,
    `sms_enabled`
FROM hahn.`home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/raw/couriers`
;
