USE hahn;
PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA yt.Owners = 'griganton';

INSERT INTO `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/summary/delivery` WITH TRUNCATE
SELECT
    order_.*,
	value_.*,
    history_.*,
    route_.*,
    courier_.*,
    (order_.status in ('finished', 'cancelled')) as successful_order_flg,
    Geo::RoundRegionByLocation(lat, lon, 'country').name as country,
    Geo::RoundRegionByLocation(lat, lon, 'city').name as city,
    Geo::RoundRegionByLocation(lat, lon, 'region').name as region,
    WITHOUT courier_.courier_id, route_.route_id, value_.routing_order_id
FROM `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/object/order` as order_
	left join `//home/taxi-delivery/international/routing_wms/value` as value_
		on value_.routing_order_id = order_.order_id
	LEFT JOIN (
		SELECT
			order_id,
			MIN(IF(event='ORDER_CREATED', utc_time_dttm, NULL)) as utc_order_created_dttm,
			MAX(IF(event='STATUS_UPDATE' and status='confirmed', utc_time_dttm, NULL)) as utc_order_confirmed_dttm,
			MAX(IF(event='STATUS_UPDATE' and status='finished', utc_time_dttm, NULL)) as utc_order_finished_dttm,
			MAX(IF(event='STATUS_UPDATE' and status='cancelled', utc_time_dttm, NULL)) as utc_order_cancelled_dttm,
			MAX(IF(event='STATUS_UPDATE' and status='postponed', utc_time_dttm, NULL)) as utc_order_postponed_dttm,
			MAX(IF(event='START', utc_time_dttm, NULL)) as utc_order_start_dttm,
			MAX(IF(event='ARRIVAL', utc_time_dttm, NULL)) as utc_order_arrival_dttm,
			MAX(IF(event='ORDER_VISIT', utc_time_dttm, NULL)) as utc_order_visit_dttm,
			MAX(IF(event='DEPARTURE', utc_time_dttm, NULL)) as utc_order_departure_dttm,
			MAX(IF(event='ORDER_BECAME_NEXT', utc_time_dttm, NULL)) as utc_order_became_next_dttm
		FROM  `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/object/order_history`
		group by order_id
	) as history_
		ON order_.order_id = history_.order_id
	LEFT JOIN (
		SELECT
			route_id,
			routing_mode,
			courier_id,
			number as route_number,
			`date` as route_date,
		FROM `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/object/routes`
	) as route_
		ON order_.route_id = route_.route_id
	JOIN (
		SELECT
			id as courier_id,
			name as courier_name,
		FROM `home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/object/couriers`
		where name not like '%_nos' -- only own supply couriers
	) as courier_
		ON courier_.courier_id = route_.courier_id;
