
use hahn;
$current_week = DateTime::MakeDate(DateTime::StartOfWeek(CurrentUtcDate()));
$path = '//home/taxi-delivery/international/clients_dash/clients_dash';

$israel_clients = (
select
  'Israel' as country
  ,DateTime::MakeDate(DateTime::StartOfWeek(cast(i.date as date))) as week
  ,corp_client_name
from `//home/taxi-delivery/analytics/international/israel_clients_dash` as i
where 0<1
  and cast(i.date as date) >= cast('2022-01-03' as date)
  and cast(i.date as date) < $current_week
);


$chile_clients = (
select
  'Chile' as country
  ,DateTime::MakeDate(DateTime::StartOfWeek(cast(route_date as date))) as week
  ,corp_client_name
from `//home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/summary/delivery`
where 0<1
  and country = 'Чили'
  and status = 'finished'
  and cast(route_date as date) >= cast('2022-01-03' as date)
  and cast(route_date as date) < $current_week
);


insert into $path with truncate
select
  country
  ,week
  ,count(distinct corp_client_name) as active_clients
from $israel_clients
group by
  country
  ,week
union all
select
  country
  ,week
  ,count(distinct corp_client_name) as active_clients
from $chile_clients
group by
  country
  ,week;
