
drop table if exists act_share_source_day;
create temp table act_share_source_day as
select
    date,
    tariff,
    country,
    city_group,
    city,
    business,
    sum(deliveries) as deliveries,
    sum(gmv) as gmv,
    sum(gmv_cards) as gmv_cards,
    sum(commissions) as commissions,
    sum(subsidies) as subsidies,
    sum(decoupling) as decoupling,
    sum(net_inflow) as net_inflow
from snb_delivery.dash_finance_estimate_source
where date_trunc('month', date) <= date_trunc('month', current_date)
group by 1,2,3,4,5,6;


drop table if exists act_share_day;
create temp table act_share_day as
select
    *,
    case
        when sum(deliveries) over(partition by date, tariff, country, business) = 0
        then 0
        else deliveries*1.0/sum(deliveries) over(partition by date, tariff, country, business)
        end as deliveries_share,
    case
        when sum(gmv) over(partition by date, tariff, country, business) = 0
        then 0
        else gmv*1.0/sum(gmv) over(partition by date, tariff, country, business)
        end as gmv_share,
    -- GMV CARDS SHARE = % FROM GMV
    case
        when sum(gmv) over(partition by date, tariff, country) = 0
        then 0
        else gmv_cards*1.0/sum(gmv) over(partition by date, tariff, country)
        end as gmv_cards_share,
    case
        when sum(commissions) over(partition by date, tariff, country, business) = 0
        then 0
        else commissions*1.0/sum(commissions) over(partition by date, tariff, country, business)
        end as commissions_share,
    case
        when sum(subsidies) over(partition by date, tariff, country, business) = 0
        then 0
        else subsidies*1.0/sum(subsidies) over(partition by date, tariff, country, business)
        end as subsidies_share,
    case
        when sum(decoupling) over(partition by date, tariff, country, business) = 0
        then 0
        else decoupling*1.0/sum(decoupling) over(partition by date, tariff, country, business)
        end as decoupling_share,
    case
        when sum(net_inflow) over(partition by date, tariff, country, business) = 0
        then 0
        else net_inflow*1.0/sum(net_inflow) over(partition by date, tariff, country, business)
        end as net_inflow_share
from
    act_share_source_day;





drop table if exists act_share_source_month;
create temp table act_share_source_month as
select
    date_trunc('month',date)::date as month,
    tariff,
    country,
    city_group,
    city,
    sum(deliveries) as deliveries,
    sum(gmv) as gmv,
    sum(gmv_cards) as gmv_cards,
    sum(commissions) as commissions,
    sum(subsidies) as subsidies,
    sum(decoupling) as decoupling,
    sum(net_inflow) as net_inflow
from act_share_day
group by 1,2,3,4,5;



drop table if exists act_share_month;
create temp table act_share_month as
select
    *,
    case
        when sum(deliveries) over(partition by month, tariff, country) = 0
        then 0
        else deliveries*1.0/sum(deliveries) over(partition by month, tariff, country)
        end as deliveries_share,
    case
        when sum(gmv) over(partition by month, tariff, country) = 0
        then 0
        else gmv*1.0/sum(gmv) over(partition by month, tariff, country)
        end as gmv_share,
    -- GMV CARDS SHARE = % FROM GMV
    case
        when sum(gmv) over(partition by month, tariff, country) = 0
        then 0
        else gmv_cards*1.0/sum(gmv) over(partition by month, tariff, country)
        end as gmv_cards_share,
    case
        when sum(commissions) over(partition by month, tariff, country) = 0
        then 0
        else commissions*1.0/sum(commissions) over(partition by month, tariff, country)
        end as commissions_share,
    case
        when sum(subsidies) over(partition by month, tariff, country) = 0
        then 0
        else subsidies*1.0/sum(subsidies) over(partition by month, tariff, country)
        end as subsidies_share,
    case
        when sum(decoupling) over(partition by month, tariff, country) = 0
        then 0
        else decoupling*1.0/sum(decoupling) over(partition by month, tariff, country)
        end as decoupling_share,
    case
        when sum(net_inflow) over(partition by month, tariff, country) = 0
        then 0
        else net_inflow*1.0/sum(net_inflow) over(partition by month, tariff, country)
        end as net_inflow_share
from
    act_share_source_month;





drop table if exists plan_split;
create temp table plan_split as
with plan as
(
        select
            date,
            date_trunc('month',date)::date as month,
            tariff,
            country,
            business,
            sum(value) filter(where metric = 'deliveries') as deliveries_plan,
            sum(value) filter(where metric = 'gmv') as gmv_plan,
            sum(value) filter(where metric = 'commissions') as commissions_plan,
            sum(value) filter(where metric = 'subsidies') as subsidies_plan,
            sum(value) filter(where metric = 'decoupling') as decoupling_plan,
            sum(value) filter(where metric = 'net_inflow') as net_inflow_plan
        from snb_delivery.plans_budget_2022_v2
        where date_trunc('month', date) <= date_trunc('month', current_date)
        group by 1,2,3,4,5
        having sum(case when metric = 'deliveries' then value else 0 end) <> 0
)
select
    coalesce(plan.date, d.date) as date,
    coalesce(plan.tariff, d.tariff) as tariff,
    coalesce(plan.country, d.country) as country,
    d.city_group,
    d.city,
    coalesce(plan.business, d.business) as business,

    plan.deliveries_plan as plan_deliveries,
    d.deliveries as fact_deliveries,
    d.deliveries_share as day_deliveries_share,
    0 as month_deliveries_share,

--     if no daily city fact split for respective plan, then use respective monthly split
--     if no plan for this date (historical dates) then use fact
    coalesce(plan.deliveries_plan*d.deliveries_share,d.deliveries) as deliveries,
    coalesce(plan.gmv_plan*d.gmv_share,d.gmv) as gmv,
    coalesce(plan.gmv_plan*d.gmv_cards_share,d.gmv_cards) as gmv_cards,
    coalesce(plan.commissions_plan*d.commissions_share,d.commissions) as commissions,
    coalesce(plan.subsidies_plan*d.subsidies_share,d.subsidies) as subsidies,
    coalesce(plan.decoupling_plan*d.decoupling_share,d.decoupling) as decoupling,
    coalesce(plan.net_inflow_plan*d.net_inflow_share,d.net_inflow) as net_inflow
from
    plan
    full join act_share_day as d
        on plan.date = d.date
        and plan.tariff = d.tariff
        and plan.country = d.country
        and plan.business = d.business
;


-- HOW DO DEAL WITH SPLITS MISSED IN PLAN

drop table if exists missed_split;
create temp table missed_split as
select date, tariff, country, business
from plan_split
where city_group is null
group by 1,2,3,4;


delete from plan_split p
using missed_split m
where p.date = m.date and p.tariff = m.tariff and p.country = m.country and p.business = m.business;


with plan as
(
        select
            date,
            date_trunc('month',date)::date as month,
            tariff,
            country,
            business,
            sum(value) filter(where metric = 'deliveries') as deliveries_plan,
            sum(value) filter(where metric = 'gmv') as gmv_plan,
            sum(value) filter(where metric = 'commissions') as commissions_plan,
            sum(value) filter(where metric = 'subsidies') as subsidies_plan,
            sum(value) filter(where metric = 'decoupling') as decoupling_plan,
            sum(value) filter(where metric = 'net_inflow') as net_inflow_plan
        from snb_delivery.plans_budget_2022_v2
        where date_trunc('month', date) <= date_trunc('month', current_date)
        group by 1,2,3,4,5
        having sum(case when metric = 'deliveries' then value else 0 end) <> 0
)
insert into plan_split
select
    plan.date as date,
    coalesce(plan.tariff, m.tariff) as tariff,
    coalesce(plan.country, m.country) as country,
    m.city_group,
    m.city,
    plan.business,

    plan.deliveries_plan as plan_deliveries,
    m.deliveries as fact_deliveries,
    0 as day_deliveries_share,
    m.deliveries_share as month_deliveries_share,

--     if no daily city fact split for respective plan, then use respective monthly split
--     if no plan for this date (historical dates) then use fact
    plan.deliveries_plan*m.deliveries_share as deliveries,
    plan.gmv_plan*m.gmv_share as gmv,
    plan.gmv_plan*m.gmv_cards_share as gmv_cards,
    plan.commissions_plan*m.commissions_share as commissions,
    plan.subsidies_plan*m.subsidies_share as subsidies,
    plan.decoupling_plan*m.decoupling_share as decoupling,
    plan.net_inflow_plan*m.net_inflow_share as net_inflow
from
    plan
    inner join missed_split
        using (date, tariff, country, business)
    inner join act_share_month as m
        on plan.month = m.month
        and plan.tariff = m.tariff
        and plan.country = m.country;







drop table if exists plans_tmp;
create temp table plans_tmp as
select
    coalesce(a.date, p.date) as date,
    coalesce(a.city, p.city) as city,
    sum(coalesce(p.deliveries,0)) as deliveries_plan,
    sum(coalesce(p.gmv,0)) as gmv_plan,
    sum(coalesce(p.gmv_cards,0)) as gmv_cards_plan,
    sum(coalesce(p.commissions,0)) as commissions_plan,
    sum(coalesce(p.subsidies,0)) as subsidies_plan,
    sum(coalesce(p.decoupling,0)) as decoupling_plan

from
    snb_delivery.dash_finance_estimate_source a
    full join plan_split p
        using(date, tariff, country, city_group, city, business)
where
    date_trunc('month', coalesce(a.date,p.date)) <= date_trunc('month', current_date)
group by
    1,2
;


drop table if exists snb_delivery.dash_bizdev_business_overview_city;
create table snb_delivery.dash_bizdev_business_overview_city as
with a as (

    select
           city,
           rank() over(order by deliveries desc) as city_rank_total,
           rank() over(partition by country order by deliveries desc) as city_rank_country
    from (
        select city, country, sum(deliveries) as deliveries
        from snb_delivery.dash_bizdev_business_overview
        where
            country in ('Замбия','Камерун','Кот-д''Ивуар','Узбекистан','Сенегал','Литва','Финляндия','Ангола',
                'Азербайджан','Казахстан','Белоруссия','Гана','Эстония','Киргизия','Латвия','Армения','Грузия','Молдавия')
            and date >= (select max(date)-interval '7' day from snb_delivery.dash_bizdev_business_overview where date < current_date)
        group by 1,2
        ) t

),

b as (
    select
        date,
        country,
        city,
        sum(deliveries) as deliveries,
        sum(orders) as orders,
        sum(trips) as trips
    from snb_delivery.dash_bizdev_business_overview
    where
        country in ('Замбия','Камерун','Кот-д''Ивуар','Узбекистан','Сенегал','Литва','Финляндия','Ангола',
                'Азербайджан','Казахстан','Белоруссия','Гана','Эстония','Киргизия','Латвия','Армения','Грузия','Молдавия')
        and date < current_date
    group by 1,2,3
    )

select
    b.date,
    country,
    b.city,
    a.city_rank_total,
    a.city_rank_country,
    deliveries,
    orders,
    trips,
    p.deliveries_plan
from
    b
    left join a on a.city = b.city
    left join plans_tmp p on p.city = b.city and p.date = b.date
