begin;
drop table if exists snb_delivery.israel_clients_dash;
create table snb_delivery.israel_clients_dash as
with clients as (
select distinct
  corp_client_id
  ,corp_client_name
from delivery_cdm_b2b.dim_corp_contract
)
select
  utc_order_created_dt as date
  ,case
  	when f.corp_client_id is null then 'NON_CORP_C2C'
	else c.corp_client_name
  end as corp_client_name
  ,sum(least(1,delivery_point_cnt)) as trips
  ,sum(delivery_point_cnt) as deliveries
  ,sum(order_cost)/1.17 as gmv
  ,sum(gross_commission_revenue_amt) as commissions
  ,sum(incentives_amt) as subsidies
  ,sum(b2b_decoupling_amt*case when decoupling_flg then 1 else 0 end) as decoupling
  ,sum(net_inflow_amt) as ni
from taxi_cdm_marketplace.fct_order_metric f
  left join clients c
    on c.corp_client_id = f.corp_client_id
where 0<1
  and success_order_flg
  and tariff_class_code in ('courier','express','night')
  and (country_name_ru = 'Израиль' or tariff_geo_zone_code = 'tel_aviv')
  and utc_order_created_dttm >= to_date('01/01/2022','dd/mm/yyyy')
  and utc_order_created_dttm < current_date::timestamp
group by
  utc_order_created_dt
  ,case
  	when f.corp_client_id is null then 'NON_CORP_C2C'
	else c.corp_client_name
  end;
commit;

grant select on snb_delivery.israel_clients_dash to public;
commit;
